/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.keyFMap;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.ArrayBackedFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;

final class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, int keyToExclude) {
        if (oldMap == null) {
            MapBackedFMap.$$$reportNull$$$0(0);
        }
        super(oldMap.size());
        oldMap.forEachEntry((key, val) -> {
            if (key != keyToExclude) {
                this.put(key, val);
            }
            assert (key >= 0) : key;
            return true;
        });
        assert (this.size() > 8);
    }

    private MapBackedFMap(@NotNull MapBackedFMap oldMap, int newKey, @NotNull Object newValue) {
        if (oldMap == null) {
            MapBackedFMap.$$$reportNull$$$0(1);
        }
        if (newValue == null) {
            MapBackedFMap.$$$reportNull$$$0(2);
        }
        super(oldMap.size() + 1);
        oldMap.forEachEntry((key, val) -> {
            this.put(key, val);
            return true;
        });
        this.put(newKey, newValue);
        assert (this.size() > 8);
    }

    MapBackedFMap(int @NotNull [] keys2, int newKey, @NotNull @NotNull Object @NotNull [] values2, @NotNull Object newValue) {
        if (values2 == null) {
            MapBackedFMap.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            MapBackedFMap.$$$reportNull$$$0(4);
        }
        if (keys2 == null) {
            MapBackedFMap.$$$reportNull$$$0(5);
        }
        super(keys2.length + 1);
        for (int i = 0; i < keys2.length; ++i) {
            int key = keys2[i];
            Object value2 = values2[i];
            this.put(key, value2);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value2) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            MapBackedFMap.$$$reportNull$$$0(7);
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value2 == oldValue) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(8);
            }
            return mapBackedFMap;
        }
        return new MapBackedFMap(this, keyCode, value2);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(9);
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(10);
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys2 = this.keys();
            int[] newKeys = ArrayUtil.remove(keys2, ArrayUtil.indexOf(keys2, keyCode));
            Arrays.sort(newKeys);
            Object[] newValues = new Object[newKeys.length];
            for (int i = 0; i < newKeys.length; ++i) {
                Object value2 = this.get(newKeys[i]);
                assert (value2 != null);
                newValues[i] = value2;
            }
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this, keyCode);
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(11);
        }
        return this.get(key.hashCode());
    }

    @Override
    public Key @NotNull [] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys());
        if (keyArray == null) {
            MapBackedFMap.$$$reportNull$$$0(12);
        }
        return keyArray;
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object value2) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value2);
                return true;
            }
        });
        return "[" + s + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalsByReference";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

