/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.PhasedBuildAction;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.internal.Exceptions;

public class ParameterValidatingConsumerConnection
implements ConsumerConnection {
    private final VersionDetails targetVersionDetails;
    private final ConsumerConnection delegate;

    public ParameterValidatingConsumerConnection(VersionDetails targetVersionDetails, ConsumerConnection connection) {
        this.targetVersionDetails = targetVersionDetails;
        this.delegate = connection;
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @Override
    public <T> T run(Class<T> type2, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        this.validateParameters(operationParameters);
        return this.delegate.run(type2, operationParameters);
    }

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        this.validateParameters(operationParameters);
        this.validateBuildActionParameters(operationParameters);
        return this.delegate.run(action, operationParameters);
    }

    @Override
    public void run(PhasedBuildAction phasedBuildAction, ConsumerOperationParameters operationParameters) {
        this.validateParameters(operationParameters);
        this.delegate.run(phasedBuildAction, operationParameters);
    }

    @Override
    public void runTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        this.validateParameters(operationParameters);
        this.delegate.runTests(testExecutionRequest, operationParameters);
    }

    @Override
    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths, ConsumerOperationParameters operationParameters) {
        this.delegate.notifyDaemonsAboutChangedPaths(changedPaths, operationParameters);
    }

    @Override
    public void stopWhenIdle(ConsumerOperationParameters operationParameters) {
        this.delegate.stopWhenIdle(operationParameters);
    }

    private void validateParameters(ConsumerOperationParameters operationParameters) {
        if (!this.targetVersionDetails.supportsEnvironmentVariablesCustomization() && operationParameters.getEnvironmentVariables() != null) {
            throw Exceptions.unsupportedFeature("environment variables customization feature", this.targetVersionDetails.getVersion(), "3.5");
        }
    }

    private void validateBuildActionParameters(ConsumerOperationParameters operationParameters) {
        if (!this.targetVersionDetails.supportsRunTasksBeforeExecutingAction() && operationParameters.getTasks() != null) {
            throw Exceptions.unsupportedFeature("forTasks() method on BuildActionExecuter", this.targetVersionDetails.getVersion(), "3.5");
        }
    }
}

