/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Transformer;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.internal.Exceptions;

public class CancellableModelBuilderBackedModelProducer
extends HasCompatibilityMapping
implements ModelProducer {
    protected final ProtocolToModelAdapter adapter;
    protected final VersionDetails versionDetails;
    protected final ModelMapping modelMapping;
    private final InternalCancellableConnection builder;
    protected final Transformer<RuntimeException, RuntimeException> exceptionTransformer;

    public CancellableModelBuilderBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalCancellableConnection builder, Transformer<RuntimeException, RuntimeException> exceptionTransformer) {
        this.adapter = adapter;
        this.versionDetails = versionDetails;
        this.modelMapping = modelMapping;
        this.builder = builder;
        this.exceptionTransformer = exceptionTransformer;
    }

    @Override
    public <T> T produceModel(Class<T> type2, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result2;
        if (!this.versionDetails.maySupportModel(type2)) {
            throw Exceptions.unsupportedModel(type2, this.versionDetails.getVersion());
        }
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(type2);
        try {
            result2 = this.builder.getModel(modelIdentifier, new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(type2, e);
        }
        catch (RuntimeException e) {
            throw this.exceptionTransformer.transform(e);
        }
        return this.applyCompatibilityMapping(this.adapter.builder(type2), operationParameters).build(result2.getModel());
    }
}

