/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.PhasedBuildAction;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.internal.Exceptions;

public abstract class AbstractConsumerConnection
extends HasCompatibilityMapping
implements ConsumerConnection {
    private final ConnectionVersion4 delegate;
    private final VersionDetails providerMetaData;

    public AbstractConsumerConnection(ConnectionVersion4 delegate, VersionDetails providerMetaData) {
        this.delegate = delegate;
        this.providerMetaData = providerMetaData;
    }

    @Override
    public void stop() {
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getMetaData().getDisplayName();
    }

    public VersionDetails getVersionDetails() {
        return this.providerMetaData;
    }

    public ConnectionVersion4 getDelegate() {
        return this.delegate;
    }

    public abstract void configure(ConnectionParameters var1);

    protected abstract ModelProducer getModelProducer();

    protected abstract ActionRunner getActionRunner();

    @Override
    public <T> T run(Class<T> type2, ConsumerOperationParameters operationParameters) {
        return this.getModelProducer().produceModel(type2, operationParameters);
    }

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) {
        return this.getActionRunner().run(action, operationParameters);
    }

    @Override
    public void run(PhasedBuildAction phasedBuildAction, ConsumerOperationParameters operationParameters) {
        throw Exceptions.unsupportedFeature(operationParameters.getEntryPointName(), this.getVersionDetails().getVersion(), "4.8");
    }

    @Override
    public void runTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        throw Exceptions.unsupportedFeature(operationParameters.getEntryPointName(), this.getVersionDetails().getVersion(), "2.6");
    }

    @Override
    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths, ConsumerOperationParameters operationParameters) {
    }

    @Override
    public void stopWhenIdle(ConsumerOperationParameters operationParameters) {
    }
}

