/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

class TypeStringFormatter {
    TypeStringFormatter() {
    }

    static String format(Type type2) {
        if (type2 instanceof Class) {
            Class aClass = (Class)type2;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                return TypeStringFormatter.format(enclosingClass) + "$" + aClass.getSimpleName();
            }
            return aClass.getSimpleName();
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            StringBuilder builder = new StringBuilder();
            builder.append(TypeStringFormatter.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(TypeStringFormatter.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type2.toString();
    }
}

