/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import org.gradle.cli.CommandLineArgumentException;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public abstract class Origin {
    protected String source;

    public static Origin forGradleProperty(String gradleProperty) {
        return new GradlePropertyOrigin(gradleProperty);
    }

    public static Origin forCommandLine(String commandLineOption) {
        return new CommandLineOrigin(commandLineOption);
    }

    private Origin(String source) {
        this.source = source;
    }

    public abstract void handleInvalidValue(String var1, String var2);

    public void handleInvalidValue(String value2) {
        this.handleInvalidValue(value2, null);
    }

    String hintMessage(String hint) {
        if (StringUtils.isBlank(hint)) {
            return "";
        }
        return String.format(" (%s)", hint);
    }

    private static class CommandLineOrigin
    extends Origin {
        public CommandLineOrigin(String value2) {
            super(value2);
        }

        @Override
        public void handleInvalidValue(String value2, String hint) {
            String message2 = String.format("Argument value '%s' given for --%s option is invalid%s", value2, this.source, this.hintMessage(hint));
            throw new CommandLineArgumentException(message2);
        }
    }

    private static class GradlePropertyOrigin
    extends Origin {
        public GradlePropertyOrigin(String value2) {
            super(value2);
        }

        @Override
        public void handleInvalidValue(String value2, String hint) {
            String message2 = String.format("Value '%s' given for %s Gradle property is invalid%s", value2, this.source, this.hintMessage(hint));
            throw new IllegalArgumentException(message2);
        }
    }
}

