/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.api.specs.Spec;
import org.gradle.cache.GlobalCache;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.util.internal.GUtil;

public class DefaultModuleRegistry
implements ModuleRegistry,
GlobalCache {
    private static final Spec<File> SATISFY_ALL = element -> true;
    @Nullable
    private final GradleInstallation gradleInstallation;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final Map<String, Module> externalModules = new HashMap<String, Module>();
    private final List<File> classpath = new ArrayList<File>();
    private final Map<String, File> classpathJars = new LinkedHashMap<String, File>();
    private static final String[] NO_PROJECTS = new String[0];

    public DefaultModuleRegistry(@Nullable GradleInstallation gradleInstallation) {
        this(ClassPath.EMPTY, gradleInstallation);
    }

    public DefaultModuleRegistry(ClassPath additionalModuleClassPath, @Nullable GradleInstallation gradleInstallation) {
        this(DefaultModuleRegistry.class.getClassLoader(), additionalModuleClassPath, gradleInstallation);
    }

    private DefaultModuleRegistry(ClassLoader classLoader, ClassPath additionalModuleClassPath, @Nullable GradleInstallation gradleInstallation) {
        this.gradleInstallation = gradleInstallation;
        for (File classpathFile : new EffectiveClassPath(classLoader).plus(additionalModuleClassPath).getAsFiles()) {
            this.classpath.add(classpathFile);
            if (!classpathFile.isFile() || this.classpathJars.containsKey(classpathFile.getName())) continue;
            this.classpathJars.put(classpathFile.getName(), classpathFile);
        }
    }

    @Override
    public List<File> getGlobalCacheRoots() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.gradleInstallation != null) {
            builder.addAll(this.gradleInstallation.getLibDirs());
        }
        builder.addAll(this.classpath);
        return builder.build();
    }

    @Override
    public ClassPath getAdditionalClassPath() {
        return this.gradleInstallation == null ? DefaultClassPath.of(this.classpath) : ClassPath.EMPTY;
    }

    @Override
    public Module getExternalModule(String name) {
        Module module2 = this.externalModules.get(name);
        if (module2 == null) {
            module2 = this.loadExternalModule(name);
            this.externalModules.put(name, module2);
        }
        return module2;
    }

    private Module loadExternalModule(String name) {
        File externalJar = this.findJar(name, SATISFY_ALL);
        if (externalJar == null) {
            if (this.gradleInstallation == null) {
                throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in classpath: %s.", name, this.classpath));
            }
            throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", name, this.gradleInstallation.getGradleHome()));
        }
        return new DefaultModule(name, Collections.singleton(externalJar), Collections.emptySet());
    }

    @Override
    public Module getModule(String name) {
        Module module2 = this.modules.get(name);
        if (module2 == null) {
            module2 = this.loadModule(name);
            this.modules.put(name, module2);
        }
        return module2;
    }

    @Override
    @Nullable
    public Module findModule(String name) {
        Module module2 = this.modules.get(name);
        if (module2 == null && (module2 = this.loadOptionalModule(name)) != null) {
            this.modules.put(name, module2);
        }
        return module2;
    }

    private Module loadModule(String moduleName) {
        Module module2 = this.loadOptionalModule(moduleName);
        if (module2 != null) {
            return module2;
        }
        if (this.gradleInstallation == null) {
            throw new UnknownModuleException(String.format("Cannot locate manifest for module '%s' in classpath: %s.", moduleName, this.classpath));
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", moduleName, this.gradleInstallation.getGradleHome()));
    }

    private Module loadOptionalModule(String moduleName) {
        File jarFile = this.findJar(moduleName, jarFile1 -> this.hasModuleProperties(moduleName, (File)jarFile1));
        if (jarFile != null) {
            LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
            implementationClasspath.add(jarFile);
            Properties properties2 = this.loadModuleProperties(moduleName, jarFile);
            return this.module(moduleName, properties2, implementationClasspath);
        }
        String resourceName = this.getClasspathManifestName(moduleName);
        LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
        this.findImplementationClasspath(moduleName, implementationClasspath);
        for (File file2 : implementationClasspath) {
            File propertiesFile;
            if (!file2.isDirectory() || !(propertiesFile = new File(file2, resourceName)).isFile()) continue;
            Properties properties3 = GUtil.loadProperties(propertiesFile);
            return this.module(moduleName, properties3, implementationClasspath);
        }
        return null;
    }

    private Module module(String moduleName, Properties properties2, Set<File> implementationClasspath) {
        String[] runtimeJarNames = this.split(properties2.getProperty("runtime"));
        Set<File> runtimeClasspath = this.findDependencyJars(moduleName, runtimeJarNames);
        String[] projects = this.split(properties2.getProperty("projects"));
        String[] optionalProjects = this.split(properties2.getProperty("optional"));
        return new DefaultModule(moduleName, implementationClasspath, runtimeClasspath, projects, optionalProjects);
    }

    private Set<File> findDependencyJars(String moduleName, String[] jarNames) {
        LinkedHashSet<File> runtimeClasspath = new LinkedHashSet<File>();
        for (String jarName : jarNames) {
            runtimeClasspath.add(this.findDependencyJar(moduleName, jarName));
        }
        return runtimeClasspath;
    }

    private Set<Module> getModules(String[] projectNames) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (String project : projectNames) {
            modules.add(this.getModule(project));
        }
        return modules;
    }

    private String[] split(String value2) {
        if (value2 == null) {
            return new String[0];
        }
        if ((value2 = value2.trim()).length() == 0) {
            return new String[0];
        }
        return value2.split(",");
    }

    private void findImplementationClasspath(String name, Collection<File> implementationClasspath) {
        String projectDirName = name.startsWith("kotlin-compiler-embeddable-") ? "kotlin-compiler-embeddable" : DefaultModuleRegistry.projectDirNameFrom(name);
        List<String> suffixesForProjectDir = this.getClasspathSuffixesForProjectDir(projectDirName);
        for (File file2 : this.classpath) {
            if (!file2.isDirectory()) continue;
            String path = file2.getAbsolutePath();
            for (String suffix : suffixesForProjectDir) {
                if (!path.endsWith(suffix)) continue;
                implementationClasspath.add(file2);
            }
        }
    }

    private static String projectDirNameFrom(String moduleName) {
        Matcher matcher = Pattern.compile("gradle-(.+)").matcher(moduleName);
        matcher.matches();
        return matcher.group(1);
    }

    private List<String> getClasspathSuffixesForProjectDir(String projectDirName) {
        ArrayList<String> suffixes = new ArrayList<String>();
        suffixes.add(("/" + projectDirName + "/out/production/classes").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/out/production/resources").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/bin").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/src/main/resources").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/classes/java/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/classes/groovy/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/resources/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/generated-resources/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/generated-resources/test").replace('/', File.separatorChar));
        return suffixes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Properties loadModuleProperties(String name, File jarFile) {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Properties properties2;
            block14: {
                String entryName = this.getClasspathManifestName(name);
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry == null) {
                    throw new IllegalStateException("Did not find " + entryName + " in " + jarFile.getAbsolutePath());
                }
                InputStream is = zipFile.getInputStream(entry);
                try {
                    properties2 = GUtil.loadProperties(is);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return properties2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not load properties for module '%s' from %s", name, jarFile), e);
        }
    }

    private boolean hasModuleProperties(String name, File jarFile) {
        boolean bl;
        ZipFile zipFile = new ZipFile(jarFile);
        try {
            String entryName = this.getClasspathManifestName(name);
            ZipEntry entry = zipFile.getEntry(entryName);
            bl = entry != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Could not load properties for module '%s' from %s", name, jarFile), e);
            }
        }
        zipFile.close();
        return bl;
    }

    private String getClasspathManifestName(String moduleName) {
        return moduleName + "-classpath.properties";
    }

    private File findJar(String name, Spec<File> allowedJarFiles) {
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "-\\d.*\\.jar");
        if (this.gradleInstallation != null) {
            for (File libDir : this.gradleInstallation.getLibDirs()) {
                for (File file2 : libDir.listFiles()) {
                    if (!pattern.matcher(file2.getName()).matches()) continue;
                    return file2;
                }
            }
        }
        for (File file3 : this.classpath) {
            if (!pattern.matcher(file3.getName()).matches() || !allowedJarFiles.isSatisfiedBy(file3)) continue;
            return file3;
        }
        return null;
    }

    private File findDependencyJar(String module2, String name) {
        File jarFile = this.classpathJars.get(name);
        if (jarFile != null) {
            return jarFile;
        }
        if (this.gradleInstallation == null) {
            throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath.", name, module2));
        }
        for (File libDir : this.gradleInstallation.getLibDirs()) {
            jarFile = new File(libDir, name);
            if (!jarFile.isFile()) continue;
            return jarFile;
        }
        throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath or distribution directory '%s'", name, module2, this.gradleInstallation.getGradleHome()));
    }

    private class DefaultModule
    implements Module {
        private final String name;
        private final String[] projects;
        private final String[] optionalProjects;
        private final ClassPath implementationClasspath;
        private final ClassPath runtimeClasspath;
        private final ClassPath classpath;

        public DefaultModule(String name, Set<File> implementationClasspath, Set<File> runtimeClasspath, String[] projects, String[] optionalProjects) {
            this.name = name;
            this.projects = projects;
            this.optionalProjects = optionalProjects;
            this.implementationClasspath = DefaultClassPath.of(implementationClasspath);
            this.runtimeClasspath = DefaultClassPath.of(runtimeClasspath);
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(implementationClasspath);
            classpath.addAll(runtimeClasspath);
            this.classpath = DefaultClassPath.of(classpath);
        }

        public DefaultModule(String name, Set<File> singleton, Set<File> files2) {
            this(name, singleton, files2, NO_PROJECTS, NO_PROJECTS);
        }

        public String toString() {
            return "module '" + this.name + "'";
        }

        @Override
        public Set<Module> getRequiredModules() {
            return DefaultModuleRegistry.this.getModules(this.projects);
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public ClassPath getRuntimeClasspath() {
            return this.runtimeClasspath;
        }

        @Override
        public ClassPath getClasspath() {
            return this.classpath;
        }

        @Override
        public Set<Module> getAllRequiredModules() {
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            this.collectRequiredModules(modules);
            return modules;
        }

        @Override
        public ClassPath getAllRequiredModulesClasspath() {
            ClassPath classPath2 = ClassPath.EMPTY;
            for (Module module2 : this.getAllRequiredModules()) {
                classPath2 = classPath2.plus(module2.getClasspath());
            }
            return classPath2;
        }

        private void collectRequiredModules(Set<Module> modules) {
            if (!modules.add(this)) {
                return;
            }
            for (Module module2 : this.getRequiredModules()) {
                this.collectDependenciesOf(module2, modules);
            }
            for (String optionalProject : this.optionalProjects) {
                Module module3 = this.findModule(optionalProject);
                if (module3 == null) continue;
                this.collectDependenciesOf(module3, modules);
            }
        }

        private void collectDependenciesOf(Module module2, Set<Module> modules) {
            ((DefaultModule)module2).collectRequiredModules(modules);
        }

        private Module findModule(String optionalProject) {
            try {
                return DefaultModuleRegistry.this.getModule(optionalProject);
            }
            catch (UnknownModuleException ex) {
                return null;
            }
        }
    }
}

