/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt$equalsHasDefaultImpl$;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt$hashCodeHasDefaultImpl$;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002\u001a8\u0010\r\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a(\u0010\u0012\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001aL\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u001aH\u0002\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001aL\u0010\u001c\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a2\u0010\u001d\u001a\u00020\u0006*\u00020\u001e2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\"\u0010\u001f\u001a\u00020\u0006*\u00020\u001e2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"ARRAYS_HASHCODE_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "EQUALS_MATCHER", "HASHCODE_MATCHER", "OBJECTS_HASH_MATCHER", "checkDotExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "klassParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "methodParameters", "", "checkEqualsExpression", "klassParameters", "", "className", "", "checkHashExpression", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkIfExpressionHasParameter", "", "first", "second", "map", "", "findParameter", "visitExpression", "equalsHasDefaultImpl", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hashCodeHasDefaultImpl", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nRedundantMethodsInDataClassesCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantMethodsInDataClassesCheck.kt\norg/sonarsource/kotlin/checks/RedundantMethodsInDataClassesCheckKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n277#2,15:218\n228#2:233\n239#2:234\n296#2:235\n277#2,15:242\n228#2:257\n239#2:258\n296#2:259\n1726#3,3:236\n1726#3,3:239\n1855#3,2:260\n1#4:262\n*S KotlinDebug\n*F\n+ 1 RedundantMethodsInDataClassesCheck.kt\norg/sonarsource/kotlin/checks/RedundantMethodsInDataClassesCheckKt\n*L\n97#1:218,15\n97#1:233\n97#1:234\n97#1:235\n136#1:242,15\n136#1:257\n136#1:258\n136#1:259\n116#1:236,3\n123#1:239,3\n151#1:260,2\n*E\n"})
public final class RedundantMethodsInDataClassesCheckKt {
    @NotNull
    private static final FunMatcherImpl EQUALS_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, EQUALS_MATCHER.1.INSTANCE, 1023, null);
    @NotNull
    private static final FunMatcherImpl HASHCODE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, HASHCODE_MATCHER.1.INSTANCE, 1023, null);
    @NotNull
    private static final FunMatcherImpl OBJECTS_HASH_MATCHER = FunMatcherKt.FunMatcher$default("java.util.Objects", "hash", null, null, false, null, null, null, null, null, null, 2044, null);
    @NotNull
    private static final FunMatcherImpl ARRAYS_HASHCODE_MATCHER = FunMatcherKt.FunMatcher$default("java.util.Arrays", "hashCode", null, null, false, null, null, null, null, null, null, 2044, null);

    /*
     * WARNING - void declaration
     */
    private static final boolean hashCodeHasDefaultImpl(KtNamedFunction $this$hashCodeHasDefaultImpl, List<? extends KtParameter> klassParameters, BindingContext bindingContext2) {
        boolean bl;
        if ($this$hashCodeHasDefaultImpl.hasBlockBody()) {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType_u24default$iv = $this$hashCodeHasDefaultImpl;
            Function1 predicate$iv = hashCodeHasDefaultImpl$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var12_11 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            List returnExpressions = (List)to$iv$iv$iv;
            if (returnExpressions.size() > 1) {
                return false;
            }
            bl = RedundantMethodsInDataClassesCheckKt.checkHashExpression(((KtReturnExpression)returnExpressions.get(0)).getReturnedExpression(), bindingContext2, klassParameters);
        } else {
            bl = RedundantMethodsInDataClassesCheckKt.checkHashExpression($this$hashCodeHasDefaultImpl.getBodyExpression(), bindingContext2, klassParameters);
        }
        return bl;
    }

    private static final boolean checkHashExpression(KtExpression expression2, BindingContext bindingContext2, List<? extends KtParameter> klassParameters) {
        if (!(expression2 instanceof KtDotQualifiedExpression)) {
            return false;
        }
        if (!(((KtDotQualifiedExpression)expression2).getSelectorExpression() instanceof KtCallExpression)) {
            return false;
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        KtCallExpression callExpression = (KtCallExpression)ktExpression;
        if (OBJECTS_HASH_MATCHER.matches(callExpression, bindingContext2)) {
            boolean bl;
            block12: {
                if (callExpression.getValueArguments().size() != klassParameters.size()) {
                    return false;
                }
                List<KtValueArgument> list2 = callExpression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl2 = false;
                        if (RedundantMethodsInDataClassesCheckKt.findParameter(it.getArgumentExpression(), klassParameters) != null) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        if (ARRAYS_HASHCODE_MATCHER.matches(callExpression, bindingContext2)) {
            boolean bl;
            block13: {
                KtExpression ktExpression2 = callExpression.getValueArguments().get(0).getArgumentExpression();
                Intrinsics.checkNotNull(ktExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                List<KtValueArgument> list3 = ((KtCallExpression)ktExpression2).getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "getValueArguments(...)");
                List<KtValueArgument> arguments2 = list3;
                if (arguments2.size() != klassParameters.size()) {
                    return false;
                }
                Iterable $this$all$iv = arguments2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl3 = false;
                        if (RedundantMethodsInDataClassesCheckKt.findParameter(it.getArgumentExpression(), klassParameters) != null) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean equalsHasDefaultImpl(KtNamedFunction $this$equalsHasDefaultImpl, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, String className) {
        boolean bl;
        if ($this$equalsHasDefaultImpl.hasBlockBody()) {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType_u24default$iv = $this$equalsHasDefaultImpl;
            Function1 predicate$iv = equalsHasDefaultImpl$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var13_12 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            List returnExpressions = (List)to$iv$iv$iv;
            if (returnExpressions.size() > 1) {
                return false;
            }
            bl = RedundantMethodsInDataClassesCheckKt.checkEqualsExpression(((KtReturnExpression)returnExpressions.get(0)).getReturnedExpression(), klassParameters, methodParameters, className);
        } else {
            bl = RedundantMethodsInDataClassesCheckKt.checkEqualsExpression($this$equalsHasDefaultImpl.getBodyExpression(), klassParameters, methodParameters, className);
        }
        return bl;
    }

    private static final boolean checkEqualsExpression(KtExpression expression2, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, String className) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = klassParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            map.put(it, false);
        }
        return RedundantMethodsInDataClassesCheckKt.visitExpression(expression2, klassParameters, methodParameters, map, className) && !map.values().contains(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean visitExpression(KtExpression expression2, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, Map<KtParameter, Boolean> map, String className) {
        if (expression2 instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual(((KtBinaryExpression)expression2).getOperationToken(), KtTokens.ANDAND)) {
                if (!RedundantMethodsInDataClassesCheckKt.visitExpression(((KtBinaryExpression)expression2).getRight(), klassParameters, methodParameters, map, className)) return false;
                if (!RedundantMethodsInDataClassesCheckKt.visitExpression(((KtBinaryExpression)expression2).getLeft(), klassParameters, methodParameters, map, className)) return false;
                return true;
            }
            if (Intrinsics.areEqual(((KtBinaryExpression)expression2).getOperationToken(), KtTokens.EQEQ)) {
                RedundantMethodsInDataClassesCheckKt.checkIfExpressionHasParameter(((KtBinaryExpression)expression2).getLeft(), ((KtBinaryExpression)expression2).getRight(), klassParameters, methodParameters, map);
                RedundantMethodsInDataClassesCheckKt.checkIfExpressionHasParameter(((KtBinaryExpression)expression2).getRight(), ((KtBinaryExpression)expression2).getLeft(), klassParameters, methodParameters, map);
                return true;
            }
        }
        if (!(expression2 instanceof KtIsExpression)) return false;
        if (((KtIsExpression)expression2).isNegated()) return false;
        KtTypeReference ktTypeReference = ((KtIsExpression)expression2).getTypeReference();
        if (!Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.nameForReceiverLabel() : null, className)) return false;
        return true;
    }

    private static final void checkIfExpressionHasParameter(KtExpression first, KtExpression second, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, Map<KtParameter, Boolean> map) {
        KtParameter ktParameter = RedundantMethodsInDataClassesCheckKt.findParameter(first, klassParameters);
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        if (RedundantMethodsInDataClassesCheckKt.checkDotExpression(second, parameter, methodParameters)) {
            map.put(parameter, true);
        }
    }

    private static final KtParameter findParameter(KtExpression expression2, List<? extends KtParameter> klassParameters) {
        KtParameter ktParameter;
        if (expression2 instanceof KtNameReferenceExpression) {
            Object v0;
            block3: {
                Iterable iterable = klassParameters;
                for (Object t : iterable) {
                    KtParameter klassParameter = (KtParameter)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(klassParameter.getName(), ((KtNameReferenceExpression)expression2).getReferencedName())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ktParameter = v0;
        } else {
            ktParameter = null;
        }
        return ktParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkDotExpression(KtExpression expression2, KtParameter klassParameter, List<KtParameter> methodParameters) {
        if (!(expression2 instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getReceiverExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        if (!Intrinsics.areEqual(((KtNameReferenceExpression)ktExpression).getReferencedName(), methodParameters.get(0).getName())) return false;
        KtExpression ktExpression2 = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        if (!Intrinsics.areEqual(((KtNameReferenceExpression)ktExpression2).getReferencedName(), klassParameter.getName())) return false;
        return true;
    }

    public static final /* synthetic */ FunMatcherImpl access$getEQUALS_MATCHER$p() {
        return EQUALS_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getHASHCODE_MATCHER$p() {
        return HASHCODE_MATCHER;
    }

    public static final /* synthetic */ boolean access$equalsHasDefaultImpl(KtNamedFunction $receiver, List klassParameters, List methodParameters, String className) {
        return RedundantMethodsInDataClassesCheckKt.equalsHasDefaultImpl($receiver, klassParameters, methodParameters, className);
    }

    public static final /* synthetic */ boolean access$hashCodeHasDefaultImpl(KtNamedFunction $receiver, List klassParameters, BindingContext bindingContext2) {
        return RedundantMethodsInDataClassesCheckKt.hashCodeHasDefaultImpl($receiver, klassParameters, bindingContext2);
    }
}

