/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContractEffectList;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPropertyAccessor
extends KtDeclarationStub<KotlinPropertyAccessorStub>
implements KtDeclarationWithBody,
KtDeclarationWithInitializer,
KtModifierListOwner {
    public KtPropertyAccessor(@NotNull ASTNode node) {
        if (node == null) {
            KtPropertyAccessor.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtPropertyAccessor(@NotNull KotlinPropertyAccessorStub stub) {
        if (stub == null) {
            KtPropertyAccessor.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType)KtStubElementTypes.PROPERTY_ACCESSOR);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtPropertyAccessor.$$$reportNull$$$0(2);
        }
        return visitor2.visitPropertyAccessor(this, data2);
    }

    public boolean isSetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return !stub.isGetter();
        }
        return this.findChildByType(KtTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.isGetter();
        }
        return this.findChildByType(KtTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public KtParameterList getParameterList() {
        return (KtParameterList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Nullable
    public KtParameter getParameter() {
        KtParameterList parameterList2 = this.getParameterList();
        if (parameterList2 == null) {
            return null;
        }
        List<KtParameter> parameters2 = parameterList2.getParameters();
        if (parameters2.isEmpty()) {
            return null;
        }
        return parameters2.get(0);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameter parameter = this.getParameter();
        if (parameter == null) {
            List<KtParameter> list2 = Collections.emptyList();
            if (list2 == null) {
                KtPropertyAccessor.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.singletonList(parameter);
        if (list3 == null) {
            KtPropertyAccessor.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null && !stub.hasBody()) {
            return null;
        }
        return AstLoadingFilter.forceAllowTreeLoading(this.getContainingFile(), () -> this.findChildByClass(KtExpression.class));
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyBlockExpression() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (!(stub == null || stub.hasBlockBody() && stub.hasBody())) {
            return null;
        }
        KtExpression bodyExpression = this.findChildByClass(KtExpression.class);
        if (bodyExpression instanceof KtBlockExpression) {
            return (KtBlockExpression)bodyExpression;
        }
        return null;
    }

    @Override
    public boolean hasBlockBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @Override
    public boolean hasBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    public KtContractEffectList getContractDescription() {
        return (KtContractEffectList)this.getStubOrPsiChild(KtStubElementTypes.CONTRACT_EFFECT_LIST);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Nullable
    public KtTypeReference getReturnTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        Object get2 = this.findChildByType(KtTokens.GET_KEYWORD);
        if (get2 != null) {
            Object t = get2;
            if (t == null) {
                KtPropertyAccessor.$$$reportNull$$$0(5);
            }
            return t;
        }
        Object t = this.findChildByType(KtTokens.SET_KEYWORD);
        if (t == null) {
            KtPropertyAccessor.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(KtTokens.LPAR);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @NotNull
    public KtProperty getProperty() {
        KtProperty ktProperty = (KtProperty)this.getParent();
        if (ktProperty == null) {
            KtPropertyAccessor.$$$reportNull$$$0(7);
        }
        return ktProperty;
    }

    @Override
    public int getTextOffset() {
        return this.getNamePlaceholder().getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPropertyAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPropertyAccessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePlaceholder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

