/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 >*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001>B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f0\u000e\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\u0016J\u001b\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0000\u00a2\u0006\u0002\b+J(\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\b\b\u0002\u0010/\u001a\u00020\u000bH\u0002J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001cH\u0014J.\u00103\u001a\u00020$2\u0006\u00104\u001a\u0002052\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010(\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0002J\u001e\u00107\u001a\u00020$2\u0006\u00104\u001a\u0002082\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J\u001e\u00109\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u001e\u0010:\u001a\u00020$2\u0006\u00104\u001a\u00020;2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J\u0012\u0010<\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J\f\u0010=\u001a\u00020\u001c*\u00020\u0016H\u0002R\u001e\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001e\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R6\u0010\u0015\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016 \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "pruneExceptionEdges", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;Z)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "insnsArray", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isMergeNode", "", "nInsns", "", "queue", "", "queued", "top", "analyze", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "getFrame", "insn", "initLocals", "current", "initLocals$backend", "mergeControlFlowEdge", "dest", "frame", "canReuse", "newFrame", "nLocals", "nStack", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "dump", "indexOf", "Companion", "backend"})
@SourceDebugExtension(value={"SMAP\nFastMethodAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastMethodAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1855#2,2:329\n12474#3,2:331\n1#4:333\n*S KotlinDebug\n*F\n+ 1 FastMethodAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer\n*L\n129#1:329,2\n189#1:331,2\n*E\n"})
public class FastMethodAnalyzer<V extends Value> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final Interpreter<V> interpreter;
    private final boolean pruneExceptionEdges;
    private final AbstractInsnNode[] insnsArray;
    private final int nInsns;
    @NotNull
    private final boolean[] isMergeNode;
    @NotNull
    private final Frame<V>[] frames;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    @JvmOverloads
    public FastMethodAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter2, boolean pruneExceptionEdges) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter2;
        this.pruneExceptionEdges = pruneExceptionEdges;
        this.insnsArray = this.method.instructions.toArray();
        this.nInsns = this.method.instructions.size();
        this.isMergeNode = Companion.findMergeNodes(this.method);
        this.frames = new Frame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    public /* synthetic */ FastMethodAnalyzer(String string2, MethodNode methodNode, Interpreter interpreter2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string2, methodNode, interpreter2, bl);
    }

    @NotNull
    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        boolean[] isTcbStart = new boolean[this.nInsns];
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
            isTcbStart[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode)) + 1] = true;
        }
        Frame<V> current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        Frame<V> handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initLocals$backend(current);
        FastMethodAnalyzer.mergeControlFlowEdge$default(this, 0, current, false, 4, null);
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            Intrinsics.checkNotNull(this.frames[insn]);
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            try {
                Frame<V> f;
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14 || insnOpcode == 0) {
                    this.mergeControlFlowEdge(insn + 1, f, true);
                } else {
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnType == 7) {
                        Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
                    } else if (insnType == 12) {
                        Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                        this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current);
                    } else if (insnType == 11) {
                        Intrinsics.checkNotNull(insnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                        this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current);
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.visitOpInsn(current, insn);
                    }
                }
                if (this.pruneExceptionEdges) {
                    boolean bl = 54 <= insnOpcode ? insnOpcode < 59 : false;
                    if (!bl && insnOpcode != 132 && !isTcbStart[insn]) continue;
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string2;
                    String string3;
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    String string4 = string3 = tcb.type;
                    if (string4 == null) {
                        string2 = "java/lang/Throwable";
                    } else {
                        Intrinsics.checkNotNullExpressionValue(string4, "tcb.type ?: \"java/lang/Throwable\"");
                        string2 = string3;
                    }
                    Type exnType = Type.getObjectType(string2);
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.handler");
                    int jump = this.indexOf(labelNode);
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(this.interpreter.newExceptionValue(tcb, handler2, exnType));
                    FastMethodAnalyzer.mergeControlFlowEdge$default(this, jump, handler2, false, 4, null);
                }
            }
            catch (AnalyzerException e) {
                AbstractInsnNode abstractInsnNode = e.node;
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue(insnList, "method.instructions");
                throw new AnalyzerException(abstractInsnNode, stringBuilder.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), e);
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue(insnList, "method.instructions");
                throw new AnalyzerException(insnNode, stringBuilder.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), e);
            }
        }
        return this.frames;
    }

    public final void initLocals$backend(@NotNull Frame<V> current) {
        boolean isInstanceMethod;
        Intrinsics.checkNotNullParameter(current, "current");
        current.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType(this.method.desc)));
        Type[] args2 = Type.getArgumentTypes(this.method.desc);
        int local = 0;
        boolean bl = isInstanceMethod = (this.method.access & 8) == 0;
        if (isInstanceMethod) {
            current.setLocal(local, this.interpreter.newParameterValue(true, local, Type.getObjectType(this.owner)));
            ++local;
        }
        Intrinsics.checkNotNullExpressionValue(args2, "args");
        for (Type arg : args2) {
            current.setLocal(local, this.interpreter.newParameterValue(isInstanceMethod, local, arg));
            ++local;
            if (arg.getSize() != 2) continue;
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
        while (local < this.method.maxLocals) {
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
    }

    private final int indexOf(AbstractInsnNode $this$indexOf) {
        return this.method.instructions.indexOf($this$indexOf);
    }

    @Nullable
    public final Frame<V> getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        return this.frames[this.indexOf(insn)];
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullExpressionValue(this.insnsArray, "insnsArray");
            Object[] $this$any$iv = this.insnsArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                boolean bl2 = false;
                if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitOpInsn(Frame<V> current, int insn) {
        FastMethodAnalyzer.mergeControlFlowEdge$default(this, insn + 1, current, false, 4, null);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, Frame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.dflt");
        FastMethodAnalyzer.mergeControlFlowEdge$default(this, this.indexOf(labelNode), current, false, 4, null);
        List<LabelNode> list2 = insnNode.labels;
        Intrinsics.checkNotNullExpressionValue(list2, "insnNode.labels");
        for (LabelNode label : CollectionsKt.asReversedMutable(list2)) {
            Intrinsics.checkNotNullExpressionValue(label, "label");
            FastMethodAnalyzer.mergeControlFlowEdge$default(this, this.indexOf(label), current, false, 4, null);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, Frame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.dflt");
        FastMethodAnalyzer.mergeControlFlowEdge$default(this, this.indexOf(labelNode), current, false, 4, null);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue(label, "label");
            FastMethodAnalyzer.mergeControlFlowEdge$default(this, this.indexOf(label), current, false, 4, null);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, Frame<V> current, int insn, int insnOpcode) {
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.label");
        FastMethodAnalyzer.mergeControlFlowEdge$default(this, this.indexOf(labelNode), current, false, 4, null);
        if (insnOpcode != 167) {
            FastMethodAnalyzer.mergeControlFlowEdge$default(this, insn + 1, current, false, 4, null);
        }
    }

    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
            int begin = this.indexOf(labelNode);
            LabelNode labelNode2 = tcb.end;
            Intrinsics.checkNotNullExpressionValue(labelNode2, "tcb.end");
            int end = this.indexOf(labelNode2);
            for (int j = begin; j < end; ++j) {
                AbstractInsnNode abstractInsnNode = this.insnsArray[j];
                Intrinsics.checkNotNullExpressionValue(abstractInsnNode, "insnsArray[j]");
                if (!UtilKt.isMeaningful(abstractInsnNode)) continue;
                List insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = (List)new SmartList();
                }
                Intrinsics.checkNotNullExpressionValue(tcb, "tcb");
                insnHandlers.add(tcb);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeControlFlowEdge(int dest, Frame<V> frame, boolean canReuse) {
        boolean changes;
        boolean bl;
        Frame<V> oldFrame = this.frames[dest];
        if (canReuse && !this.isMergeNode[dest]) {
            this.frames[dest] = frame;
            bl = true;
        } else if (oldFrame == null) {
            void $this$mergeControlFlowEdge_u24lambda_u242;
            Frame<V> frame2;
            Frame<V> frame3 = frame2 = this.newFrame(frame.getLocals(), frame.getMaxStackSize());
            int n = dest;
            Frame<V>[] frameArray = this.frames;
            boolean bl2 = false;
            $this$mergeControlFlowEdge_u24lambda_u242.init(frame);
            Unit unit = Unit.INSTANCE;
            frameArray[n] = frame2;
            bl = true;
        } else if (!this.isMergeNode[dest]) {
            oldFrame.init(frame);
            bl = true;
        } else {
            boolean bl3;
            try {
                bl3 = oldFrame.merge(frame, this.interpreter);
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(null, e.getMessage() + "\nframe: " + this.dump(frame) + "\noldFrame: " + this.dump(oldFrame));
            }
            bl = changes = bl3;
        }
        if (changes && !this.queued[dest]) {
            this.queued[dest] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = dest;
        }
    }

    static /* synthetic */ void mergeControlFlowEdge$default(FastMethodAnalyzer fastMethodAnalyzer, int n, Frame frame, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mergeControlFlowEdge");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        fastMethodAnalyzer.mergeControlFlowEdge(n, frame, bl);
    }

    private final String dump(Frame<V> $this$dump) {
        StringBuilder stringBuilder;
        StringBuilder $this$dump_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dump_u24lambda_u243.append("{\n");
        $this$dump_u24lambda_u243.append("  locals: [\n");
        int n = this.method.maxLocals;
        for (int i = 0; i < n; ++i) {
            $this$dump_u24lambda_u243.append("    #" + i + ": " + $this$dump.getLocal(i) + '\n');
        }
        $this$dump_u24lambda_u243.append("  ]\n");
        int stackSize = $this$dump.getStackSize();
        $this$dump_u24lambda_u243.append("  stack: size=");
        $this$dump_u24lambda_u243.append(stackSize);
        if (stackSize == 0) {
            $this$dump_u24lambda_u243.append(" []\n");
        } else {
            $this$dump_u24lambda_u243.append(" [\n");
            for (int i = 0; i < stackSize; ++i) {
                $this$dump_u24lambda_u243.append("    #" + i + ": " + $this$dump.getStack(i) + '\n');
            }
            $this$dump_u24lambda_u243.append("  ]\n");
        }
        $this$dump_u24lambda_u243.append("}\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @JvmOverloads
    public FastMethodAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        this(owner, method, interpreter2, false, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer$Companion;", "", "()V", "findMergeNodes", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final boolean[] findMergeNodes(@NotNull MethodNode method) {
            Intrinsics.checkNotNullParameter(method, "method");
            boolean[] isMergeNode = new boolean[method.instructions.size()];
            block5: for (AbstractInsnNode insn : method.instructions) {
                switch (insn.getType()) {
                    case 7: {
                        Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                        isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)jumpInsn.label))] = true;
                        continue block5;
                    }
                    case 12: {
                        Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                        AbstractInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                        isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)switchInsn.dflt))] = true;
                        for (LabelNode label : switchInsn.labels) {
                            isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                        }
                        continue block5;
                    }
                    case 11: {
                        Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                        AbstractInsnNode switchInsn = (TableSwitchInsnNode)insn;
                        isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)((TableSwitchInsnNode)switchInsn).dflt))] = true;
                        for (LabelNode label : ((TableSwitchInsnNode)switchInsn).labels) {
                            isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                        }
                        continue block5;
                    }
                }
            }
            for (TryCatchBlockNode tcb : method.tryCatchBlocks) {
                isMergeNode[method.instructions.indexOf((AbstractInsnNode)((AbstractInsnNode)tcb.handler))] = true;
            }
            return isMergeNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

