/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.WrapperConfiguration;

public class PathAssembler {
    public static final String GRADLE_USER_HOME_STRING = "GRADLE_USER_HOME";
    public static final String PROJECT_STRING = "PROJECT";
    private final File gradleUserHome;
    private final File projectDirectory;

    public PathAssembler(File gradleUserHome, File projectDirectory) {
        this.gradleUserHome = gradleUserHome;
        this.projectDirectory = projectDirectory;
    }

    public LocalDistribution getDistribution(WrapperConfiguration configuration) {
        String baseName = this.getDistName(configuration.getDistribution());
        String distName = this.removeExtension(baseName);
        String rootDirName = this.rootDirName(distName, configuration);
        File distDir = new File(this.getBaseDir(configuration.getDistributionBase()), configuration.getDistributionPath() + "/" + rootDirName);
        File distZip = new File(this.getBaseDir(configuration.getZipBase()), configuration.getZipPath() + "/" + rootDirName + "/" + baseName);
        return new LocalDistribution(distDir, distZip);
    }

    private String rootDirName(String distName, WrapperConfiguration configuration) {
        String urlHash = this.getHash(Download.safeUri(configuration.getDistribution()).toString());
        return distName + "/" + urlHash;
    }

    private String getHash(String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = string2.getBytes();
            messageDigest.update(bytes);
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not hash input string.", e);
        }
    }

    private String removeExtension(String name) {
        int p = name.lastIndexOf(".");
        if (p < 0) {
            return name;
        }
        return name.substring(0, p);
    }

    private String getDistName(URI distUrl) {
        String path2 = distUrl.getPath();
        int p = path2.lastIndexOf("/");
        if (p < 0) {
            return path2;
        }
        return path2.substring(p + 1);
    }

    private File getBaseDir(String base) {
        if (base.equals(GRADLE_USER_HOME_STRING)) {
            return this.gradleUserHome;
        }
        if (base.equals(PROJECT_STRING)) {
            return this.projectDirectory;
        }
        throw new RuntimeException("Base: " + base + " is unknown");
    }

    public static class LocalDistribution {
        private final File distZip;
        private final File distDir;

        public LocalDistribution(File distDir, File distZip) {
            this.distDir = distDir;
            this.distZip = distZip;
        }

        public File getDistributionDir() {
            return this.distDir;
        }

        public File getZipFile() {
            return this.distZip;
        }
    }
}

