/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.Factory;

public final class Factories {
    private Factories() {
    }

    public static <T> Factory<T> toFactory(final Runnable runnable) {
        return new Factory<T>(){

            @Override
            public T create() {
                runnable.run();
                return null;
            }
        };
    }

    public static <T> Factory<T> constant(final T item) {
        return new Factory<T>(){

            @Override
            public T create() {
                return item;
            }
        };
    }

    public static <T> Factory<T> softReferenceCache(Factory<T> factory) {
        return new CachingSoftReferenceFactory<T>(factory);
    }

    private static class CachingSoftReferenceFactory<T>
    implements Factory<T> {
        private final Factory<T> factory;
        private final AtomicReference<SoftReference<T>> cachedReference = new AtomicReference();

        public CachingSoftReferenceFactory(Factory<T> factory) {
            this.factory = factory;
        }

        @Override
        public T create() {
            Object value2;
            SoftReference<T> reference = this.cachedReference.get();
            Object t = value2 = reference != null ? (Object)reference.get() : null;
            if (value2 == null) {
                value2 = this.factory.create();
                this.cachedReference.set(new SoftReference<Object>(value2));
            }
            return value2;
        }
    }
}

