/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(@NotNull FqName $this$isSubpackageOf, @NotNull FqName packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isSubpackageOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (Intrinsics.areEqual($this$isSubpackageOf, packageName)) {
            bl = true;
        } else if (packageName.isRoot()) {
            bl = true;
        } else {
            String string2 = $this$isSubpackageOf.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "this.asString()");
            String string3 = string2;
            string2 = packageName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "packageName.asString()");
            bl = FqNamesUtilKt.isSubpackageOf(string3, string2);
        }
        return bl;
    }

    public static final boolean isChildOf(@NotNull FqName $this$isChildOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter($this$isChildOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return Intrinsics.areEqual(FqNamesUtilKt.parentOrNull($this$isChildOf), packageName);
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default(subpackageNameStr, packageNameStr, false, 2, null) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }

    @NotNull
    public static final FqName tail(@NotNull FqName $this$tail, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$tail, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (!FqNamesUtilKt.isSubpackageOf($this$tail, prefix) || prefix.isRoot()) {
            fqName2 = $this$tail;
        } else if (Intrinsics.areEqual($this$tail, prefix)) {
            FqName fqName3 = FqName.ROOT;
            Intrinsics.checkNotNullExpressionValue(fqName3, "ROOT");
            fqName2 = fqName3;
        } else {
            String string2 = $this$tail.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString()");
            String string3 = string2.substring(prefix.asString().length() + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            FqName fqName4 = new FqName(string3);
            fqName2 = fqName4;
        }
        return fqName2;
    }

    @Nullable
    public static final FqName parentOrNull(@NotNull FqName $this$parentOrNull) {
        Intrinsics.checkNotNullParameter($this$parentOrNull, "<this>");
        return $this$parentOrNull.isRoot() ? null : $this$parentOrNull.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName2) {
        if (qualifiedName2 == null) {
            return false;
        }
        State state = State.BEGINNING;
        String string2 = qualifiedName2;
        block4: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            State state2 = state;
            int n = WhenMappings.$EnumSwitchMapping$0[state2.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c != '.') continue block4;
                    state = State.AFTER_DOT;
                    continue block4;
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <V> V findValueForMostSpecificFqname(@NotNull FqName $this$findValueForMostSpecificFqname, @NotNull Map<FqName, ? extends V> values) {
        Object v1;
        Object object;
        Map map;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findValueForMostSpecificFqname, "<this>");
        Intrinsics.checkNotNullParameter(values, "values");
        Map<FqName, ? extends V> $this$filter$iv = values;
        boolean $i$f$filter = false;
        Map<FqName, ? extends V> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$fqName$_u24__u24 = element$iv$iv = iterator2.next();
            boolean bl = false;
            FqName fqName2 = (FqName)$dstr$fqName$_u24__u24.getKey();
            if (!(Intrinsics.areEqual($this$findValueForMostSpecificFqname, fqName2) || FqNamesUtilKt.isChildOf($this$findValueForMostSpecificFqname, fqName2))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map it = map = destination$iv$iv;
        boolean bl = false;
        Object object2 = object = !it.isEmpty() ? map : null;
        if (object == null) {
            return null;
        }
        Object suitableItems = object;
        map = suitableItems;
        Iterable iterable = map.entrySet();
        Iterator iterator3 = iterable.iterator();
        if (!iterator3.hasNext()) {
            v1 = null;
        } else {
            Object t = iterator3.next();
            if (!iterator3.hasNext()) {
                v1 = t;
            } else {
                Map.Entry $dstr$fqName$_u24__u24 = (Map.Entry)t;
                boolean bl2 = false;
                FqName fqName3 = (FqName)$dstr$fqName$_u24__u24.getKey();
                int n = FqNamesUtilKt.tail(fqName3, $this$findValueForMostSpecificFqname).asString().length();
                do {
                    Object t2 = iterator3.next();
                    Map.Entry $dstr$fqName$_u24__u242 = (Map.Entry)t2;
                    $i$a$-minByOrNull-FqNamesUtilKt$findValueForMostSpecificFqname$1 = false;
                    FqName fqName4 = (FqName)$dstr$fqName$_u24__u242.getKey();
                    int n2 = FqNamesUtilKt.tail(fqName4, $this$findValueForMostSpecificFqname).asString().length();
                    if (n <= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator3.hasNext());
                v1 = t;
            }
        }
        object = v1;
        return object == null ? null : (V)object.getValue();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.BEGINNING.ordinal()] = 1;
            nArray[State.AFTER_DOT.ordinal()] = 2;
            nArray[State.MIDDLE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

