/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.rules.CssRule;
import org.sonar.css.rules.RuleUtils;

@Rule(key="S4660")
public class SelectorPseudoElementNoUnknown
implements CssRule {
    private static final String DEFAULT_IGNORE_PSEUDO_ELEMENTS = "ng-deep,v-deep,deep";
    @RuleProperty(key="ignorePseudoElements", description="Comma-separated list of regular expressions or strings to ignore (e.g. /^custom-/).", defaultValue="ng-deep,v-deep,deep")
    String ignorePseudoElements = "ng-deep,v-deep,deep";

    @Override
    public String stylelintKey() {
        return "selector-pseudo-element-no-unknown";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnorePseudoElementsOption(RuleUtils.splitAndTrim(this.ignorePseudoElements)));
    }

    private static class StylelintIgnorePseudoElementsOption {
        private final List<String> ignorePseudoElements;

        StylelintIgnorePseudoElementsOption(List<String> ignorePseudoElements) {
            this.ignorePseudoElements = ignorePseudoElements;
        }
    }
}

