/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.metrics;

import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import org.sonar.css.metrics.CssTokenType;
import org.sonar.sslr.channel.Channel;

public final class CssLexer {
    private static final String NEW_LINE = "(?:\r\n|\r|\n|\f)";
    private static final String WHITESPACE = "[\t\n\f\r ]";
    private static final String NON_ASCII = "[^\\p{ASCII}]";
    private static final String HEX_DIGIT = "0-9a-fA-F";
    private static final String ESCAPE = "(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F]";
    private static final String PUNCTUATOR = "[!:,;%&+#\\*-/=>\\(\\)\\[\\]\\{\\}]";
    private static final String MULTI_LINE_COMMENT = "(?s)/\\*.*?\\*/";
    private static final String INLINE_COMMENT = "//[^\n\r\f]*+";
    private static final String NUMBER = "[+|-]?+(?:\\d++(?:\\.\\d++)?+|\\.\\d++)(?:[a-z]++|%)?+";
    private static final String NAME_CHAR = "[a-zA-Z0-9_-]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F]";
    private static final String NAME_START = "[a-zA-Z_]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F]";
    private static final String IDENTIFIER = "-?+(?:[a-zA-Z_]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])(?:[a-zA-Z0-9_-]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])*+";
    private static final String AT_IDENTIFIER = "@++-?+(?:[a-zA-Z_]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])(?:[a-zA-Z0-9_-]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])*+";
    private static final String HASH_IDENTIFIER = "#(?:[a-zA-Z0-9_-]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])++";
    private static final String DOLLAR_IDENTIFIER = "\\$(?:[a-zA-Z0-9_-]|[^\\p{ASCII}]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F])++";
    private static final String DOUBLE_QUOTE_STRING = "~?+\"(?:[^\"\\\\\r\n\f]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F]|\\\\(?:\r\n|\r|\n|\f))*+\"";
    private static final String SINGLE_QUOTE_STRING = "~?+'(?:[^'\\\\\r\n\f]|(?:\\\\[0-9a-fA-F]{1,6}[\t\n\f\r ]?)|\\[^\r\n\f0-9a-fA-F]|\\\\(?:\r\n|\r|\n|\f))*+'";

    private CssLexer() {
    }

    public static Lexer create() {
        return Lexer.builder().withFailIfNoChannelToConsumeOneCharacter(false).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.COMMENT, (String[])new String[]{MULTI_LINE_COMMENT})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.COMMENT, (String[])new String[]{INLINE_COMMENT})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.STRING, (String[])new String[]{DOUBLE_QUOTE_STRING})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.STRING, (String[])new String[]{SINGLE_QUOTE_STRING})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.AT_IDENTIFIER, (String[])new String[]{AT_IDENTIFIER})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.HASH_IDENTIFIER, (String[])new String[]{HASH_IDENTIFIER})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.DOLLAR_IDENTIFIER, (String[])new String[]{DOLLAR_IDENTIFIER})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.IDENTIFIER, (String[])new String[]{IDENTIFIER})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.NUMBER, (String[])new String[]{NUMBER})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CssTokenType.PUNCTUATOR, (String[])new String[]{PUNCTUATOR})).build();
    }
}

