/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3984")
public class UnusedThrowableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        if (newClassTree.symbolType().isSubtypeOf("java.lang.Throwable")) {
            Tree parent = newClassTree.parent();
            if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)newClassTree).withMessage("Throw this exception or remove this useless statement.").withQuickFixes(() -> Arrays.asList(JavaQuickFix.newQuickFix((String)"Add \"throw\"").addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)newClassTree, (String)"throw ")}).build(), JavaQuickFix.newQuickFix((String)"Remove the statement").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)parent)}).build())).report();
            }
        }
    }
}

