/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UnusedPrivateMethod", repositoryKey="squid")
@Rule(key="S1144")
public class UnusedPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        UnusedResolvedMethodCollector collector = new UnusedResolvedMethodCollector();
        tree.accept((TreeVisitor)collector);
        this.reportUnusedPrivateMethods(collector.getUnusedResolvedPrivateMethods());
    }

    private void reportUnusedPrivateMethods(List<MethodTree> methods) {
        methods.forEach(methodTree -> {
            IdentifierTree simpleName = methodTree.simpleName();
            String methodType = methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method";
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)simpleName).withMessage("Remove this unused private \"%s\" %s.", new Object[]{simpleName.name(), methodType}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove the unused %s", (Object[])new Object[]{methodType}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)QuickFixHelper.previousToken((Tree)methodTree), (boolean)false, (Tree)methodTree, (boolean)true))}).build()).report();
        });
    }

    private static class UnusedResolvedMethodCollector
    extends BaseTreeVisitor {
        private final List<MethodTree> unusedPrivateMethods = new ArrayList<MethodTree>();
        private final Set<String> unresolvedMethodNames = new HashSet<String>();

        private UnusedResolvedMethodCollector() {
        }

        public void visitClass(ClassTree tree) {
            super.visitClass(tree);
            this.addUnusedPrivateMethods(tree);
        }

        private void addUnusedPrivateMethods(ClassTree tree) {
            UnusedMethodCollector collector = new UnusedMethodCollector(this.unresolvedMethodNames);
            tree.members().forEach(it -> it.accept((TreeVisitor)collector));
            List<MethodTree> unusedMethods = collector.unusedPrivateMethods;
            if (unusedMethods.isEmpty()) {
                return;
            }
            Set<String> methodNames = unusedMethods.stream().map(it -> it.simpleName().name()).collect(Collectors.toSet());
            MethodsUsedInAnnotationsFilter filter = new MethodsUsedInAnnotationsFilter(methodNames);
            tree.accept((TreeVisitor)filter);
            List<String> methodSourceAnnotatedMethods = UnusedResolvedMethodCollector.getMethodSourcesNames(tree);
            unusedMethods.stream().filter(it -> filter.filteredNames.contains(it.simpleName().name())).filter(it -> !methodSourceAnnotatedMethods.contains(it.simpleName().name())).collect(Collectors.toCollection(() -> this.unusedPrivateMethods));
        }

        public List<MethodTree> getUnusedResolvedPrivateMethods() {
            return this.unusedPrivateMethods.stream().filter(it -> !this.unresolvedMethodNames.contains(it.simpleName().name())).toList();
        }

        private static List<String> getMethodSourcesNames(ClassTree tree) {
            return tree.members().stream().filter(it -> {
                MethodTree mt;
                return it instanceof MethodTree && UnusedResolvedMethodCollector.isAnnotatedWithMethodSource(mt = (MethodTree)it);
            }).map(MethodTree.class::cast).map(it -> it.simpleName().name()).toList();
        }

        private static boolean isAnnotatedWithMethodSource(MethodTree methodTree) {
            return methodTree.modifiers().annotations().stream().anyMatch(annotation -> annotation.annotationType().symbolType().is("org.junit.jupiter.params.provider.MethodSource"));
        }
    }

    private static class MethodsUsedInAnnotationsFilter
    extends BaseTreeVisitor {
        private final Set<String> filteredNames;

        public MethodsUsedInAnnotationsFilter(Set<String> methodNames) {
            this.filteredNames = methodNames;
        }

        private static boolean isNameIndicatingMethod(String name) {
            return name.toLowerCase(Locale.getDefault()).contains("method");
        }

        private void removeMethodName(LiteralTree literal) {
            this.filteredNames.remove(MethodsUsedInAnnotationsFilter.removeQuotes(literal.value()));
        }

        private static String removeQuotes(String withQuotes) {
            return withQuotes.substring(1, withQuotes.length() - 1);
        }

        public void visitAnnotation(AnnotationTree annotationTree) {
            boolean isMethodAnnotation = MethodsUsedInAnnotationsFilter.isNameIndicatingMethod(annotationTree.annotationType().symbolType().name());
            for (ExpressionTree arg : annotationTree.arguments()) {
                AssignmentExpressionTree asgn;
                if (arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                    if (!isMethodAnnotation) continue;
                    this.removeMethodName((LiteralTree)arg);
                    continue;
                }
                if (!(arg instanceof AssignmentExpressionTree) || !(asgn = (AssignmentExpressionTree)arg).expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || !isMethodAnnotation && !MethodsUsedInAnnotationsFilter.isNameIndicatingMethod(((IdentifierTree)asgn.variable()).name())) continue;
                this.removeMethodName((LiteralTree)asgn.expression());
            }
        }
    }

    private static class UnusedMethodCollector
    extends BaseTreeVisitor {
        public final List<MethodTree> unusedPrivateMethods = new ArrayList<MethodTree>();
        public final Set<String> allUnresolvedMethodNames;
        private static final Set<String> PARAM_ANNOTATION_EXCEPTIONS = Set.of("javax.enterprise.event.Observes", "jakarta.enterprise.event.Observes");

        private UnusedMethodCollector(Set<String> allUnresolvedMethodNames) {
            this.allUnresolvedMethodNames = allUnresolvedMethodNames;
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitMethod(MethodTree methodTree) {
            super.visitMethod(methodTree);
            Symbol.MethodSymbol symbol = methodTree.symbol();
            if (UnusedMethodCollector.isUnusedPrivate((Symbol)symbol) && UnusedMethodCollector.hasNoAnnotation(methodTree) && (UnusedMethodCollector.isConstructorWithParameters(methodTree) || UnusedMethodCollector.isNotMethodFromSerializable(methodTree, (Symbol)symbol))) {
                this.unusedPrivateMethods.add(methodTree);
            }
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            super.visitMethodInvocation(mit);
            String name = ExpressionUtils.methodName((MethodInvocationTree)mit).name();
            this.addIfArgumentsAreUnknown(mit.arguments(), name);
            this.addIfUnknownOrAmbiguous((Symbol)mit.methodSymbol(), name);
        }

        public void visitMethodReference(MethodReferenceTree mref) {
            super.visitMethodReference(mref);
            IdentifierTree methodIdentifier = mref.method();
            this.addIfUnknownOrAmbiguous(methodIdentifier.symbol(), methodIdentifier.name());
        }

        public void visitNewClass(NewClassTree nct) {
            super.visitNewClass(nct);
            String name = UnusedMethodCollector.constructorName(nct.identifier());
            this.addIfArgumentsAreUnknown(nct.arguments(), name);
            this.addIfUnknownOrAmbiguous((Symbol)nct.methodSymbol(), name);
        }

        private void addIfArgumentsAreUnknown(Arguments arguments, String name) {
            if (arguments.stream().anyMatch(arg -> arg.symbolType().isUnknown())) {
                this.allUnresolvedMethodNames.add(name);
            }
        }

        private void addIfUnknownOrAmbiguous(Symbol symbol, String name) {
            if (symbol.isUnknown() || symbol.isMethodSymbol() && ((Symbol.MethodSymbol)symbol).parameterTypes().stream().anyMatch(Type::isUnknown)) {
                this.allUnresolvedMethodNames.add(name);
            }
        }

        private static String constructorName(TypeTree typeTree) {
            return switch (typeTree.kind()) {
                case Tree.Kind.PARAMETERIZED_TYPE -> UnusedMethodCollector.constructorName(((ParameterizedTypeTree)typeTree).type());
                case Tree.Kind.MEMBER_SELECT -> ((MemberSelectExpressionTree)typeTree).identifier().name();
                case Tree.Kind.IDENTIFIER -> ((IdentifierTree)typeTree).name();
                default -> throw new IllegalStateException("Unexpected TypeTree used as constructor.");
            };
        }

        private static boolean isUnusedPrivate(Symbol symbol) {
            return symbol.isPrivate() && symbol.usages().isEmpty();
        }

        private static boolean hasNoAnnotation(MethodTree methodTree) {
            return methodTree.modifiers().annotations().isEmpty() && methodTree.parameters().stream().noneMatch(UnusedMethodCollector::hasAllowedAnnotation);
        }

        private static boolean hasAllowedAnnotation(VariableTree variableTree) {
            List annotations = variableTree.modifiers().annotations();
            return !annotations.isEmpty() && annotations.stream().anyMatch(UnusedMethodCollector::isAllowedAnnotation);
        }

        private static boolean isAllowedAnnotation(AnnotationTree annotation) {
            Type annotationSymbolType = annotation.symbolType();
            if (PARAM_ANNOTATION_EXCEPTIONS.stream().anyMatch(arg_0 -> ((Type)annotationSymbolType).is(arg_0))) {
                return true;
            }
            if (annotationSymbolType.isUnknown()) {
                TypeTree annotationType = annotation.annotationType();
                if (annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return "Observes".equals(((IdentifierTree)annotationType).name());
                }
                if (annotationType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    String concatenatedAnnotation = ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)annotationType));
                    return PARAM_ANNOTATION_EXCEPTIONS.stream().anyMatch(concatenatedAnnotation::equals);
                }
            }
            return false;
        }

        private static boolean isConstructorWithParameters(MethodTree methodTree) {
            return methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !methodTree.parameters().isEmpty();
        }

        private static boolean isNotMethodFromSerializable(MethodTree methodTree, Symbol symbol) {
            return methodTree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !SerializableContract.SERIALIZABLE_CONTRACT_METHODS.contains(symbol.name());
        }
    }
}

