/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.sustainability;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6914")
public class AndroidFusedLocationProviderClientCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"android.content.Context"}).names(new String[]{"getSystemService"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree nameArg = (ExpressionTree)tree.arguments().get(0);
        if ("location".equals(ExpressionUtils.resolveAsConstant((ExpressionTree)nameArg))) {
            this.reportIfInAndroidContext((Tree)nameArg);
        }
    }

    private void reportIfInAndroidContext(Tree tree) {
        if (this.context.inAndroidContext()) {
            this.reportIssue(tree, "Use \"FusedLocationProviderClient\" instead of \"LocationManager\".");
        }
    }
}

