/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2230")
public class TransactionalMethodVisibilityCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> proxyAnnotations = List.of("org.springframework.transaction.annotation.Transactional", "org.springframework.scheduling.annotation.Async");
    private static final Map<String, String> annShortName = Map.of("org.springframework.transaction.annotation.Transactional", "@Transactional", "org.springframework.scheduling.annotation.Async", "@Async");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        if (!method.symbol().isPublic()) {
            proxyAnnotations.stream().filter(annSymbol -> TransactionalMethodVisibilityCheck.hasAnnotation(method, annSymbol)).forEach(annSymbol -> this.reportIssue((Tree)method.simpleName(), "Make this method \"public\" or remove the \"" + annShortName.get(annSymbol) + "\" annotation."));
        }
    }

    private static boolean hasAnnotation(MethodTree method, String annotationSymbol) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            if (!annotation.symbolType().is(annotationSymbol)) continue;
            return true;
        }
        return false;
    }
}

