/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6837")
public class SuperfluousResponseBodyAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree ct = (ClassTree)tree;
        if (!ct.symbol().metadata().isAnnotatedWith("org.springframework.web.bind.annotation.RestController")) {
            return;
        }
        ct.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).forEach(member -> {
            MethodTree mt = (MethodTree)member;
            mt.modifiers().annotations().stream().filter(annotationTree -> annotationTree.symbolType().is("org.springframework.web.bind.annotation.ResponseBody")).findFirst().ifPresent(annotationTree -> this.reportIssue((Tree)annotationTree, "Remove this superfluous \"@ResponseBody\" annotation."));
        });
    }
}

