/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S6863")
public class StatusCodesOnResponseCheck
extends IssuableSubscriptionVisitor {
    public static final String RESPONSE_ENTITY = "org.springframework.http.ResponseEntity";
    public static final String ISSUE_MESSAGE = "Set a HttpStatus code reflective of the operation.";
    private static final List<String> OK_CODES = List.of("ACCEPTED", "ALREADY_REPORTED", "CHECKPOINT", "CONTINUE", "CREATED", "FOUND", "IM_USED", "MOVED_PERMANENTLY", "MULTIPLE_CHOICES", "MULTI_STATUS", "NON_AUTHORITATIVE_INFORMATION", "NOT_MODIFIED", "NO_CONTENT", "OK", "PARTIAL_CONTENT", "PERMANENT_REDIRECT", "PROCESSING", "RESET_CONTENT", "SEE_OTHER", "SWITCHING_PROTOCOLS", "TEMPORARY_REDIRECT");
    private static final List<String> ERROR_CODES = List.of("BAD_GATEWAY", "BAD_REQUEST", "BANDWIDTH_LIMIT_EXCEEDED", "CONFLICT", "EXPECTATION_FAILED", "FAILED_DEPENDENCY", "FORBIDDEN", "GATEWAY_TIMEOUT", "GONE", "HTTP_VERSION_NOT_SUPPORTED", "INSUFFICIENT_STORAGE", "INTERNAL_SERVER_ERROR", "I_AM_A_TEAPOT", "LENGTH_REQUIRED", "LOCKED", "LOOP_DETECTED", "METHOD_NOT_ALLOWED", "NETWORK_AUTHENTICATION_REQUIRED", "NOT_ACCEPTABLE", "NOT_EXTENDED", "NOT_FOUND", "NOT_IMPLEMENTED", "PAYLOAD_TOO_LARGE", "PAYMENT_REQUIRED", "PRECONDITION_FAILED", "PRECONDITION_REQUIRED", "PROXY_AUTHENTICATION_REQUIRED", "REQUESTED_RANGE_NOT_SATISFIABLE", "REQUEST_HEADER_FIELDS_TOO_LARGE", "REQUEST_TIMEOUT", "SERVICE_UNAVAILABLE", "TOO_MANY_REQUESTS", "UNAUTHORIZED", "UNAVAILABLE_FOR_LEGAL_REASONS", "UNPROCESSABLE_ENTITY", "UNSUPPORTED_MEDIA_TYPE", "UPGRADE_REQUIRED", "URI_TOO_LONG", "VARIANT_ALSO_NEGOTIATES");
    private static final MethodMatchers STATUS_METHOD_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.http.ResponseEntity"}).names(new String[]{"status"}).addParametersMatcher(new String[]{"org.springframework.http.HttpStatus"}).build();
    private static final MethodMatchers OK_METHOD_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.http.ResponseEntity"}).names(new String[]{"ok", "created", "accepted", "noContent"}).withAnyParameters().build();
    private static final MethodMatchers ERROR_METHODS_MATCHER = MethodMatchers.create().ofTypes(new String[]{"org.springframework.http.ResponseEntity"}).names(new String[]{"badRequest", "notFound", "unprocessableEntity"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!StatusCodesOnResponseCheck.isClassController(classTree)) {
            return;
        }
        MethodInvocationVisitor methodInvocationVisitor = new MethodInvocationVisitor();
        classTree.accept((TreeVisitor)methodInvocationVisitor);
    }

    private static Parents getParentsTryAndIf(Tree tree) {
        boolean foundIfStatement = false;
        boolean foundTryStatement = false;
        for (Tree parent = tree.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}); parent = parent.parent()) {
            if (parent.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                foundIfStatement = true;
            }
            if (!parent.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) continue;
            foundTryStatement = true;
            break;
        }
        return new Parents(foundIfStatement, foundTryStatement);
    }

    private static boolean isClassController(ClassTree classTree) {
        return Stream.of("org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController").anyMatch(annotation -> classTree.symbol().metadata().isAnnotatedWith(annotation));
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (STATUS_METHOD_MATCHERS.matches(methodInvocationTree)) {
                this.checkTryCatch(methodInvocationTree);
                return;
            }
            if (OK_METHOD_MATCHERS.matches(methodInvocationTree)) {
                Tree catchParent = this.checkCatch(methodInvocationTree, false);
                if (catchParent == null) {
                    this.checkTry(methodInvocationTree, true);
                }
                return;
            }
            if (ERROR_METHODS_MATCHER.matches(methodInvocationTree)) {
                Tree catchParent = this.checkCatch(methodInvocationTree, true);
                if (catchParent == null) {
                    this.checkTry(methodInvocationTree, false);
                }
                return;
            }
            super.visitMethodInvocation(methodInvocationTree);
        }

        private void checkTryCatch(MethodInvocationTree methodInvocationTree) {
            Tree catchParent = ExpressionUtils.getParentOfType((Tree)methodInvocationTree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CATCH});
            boolean isError = this.isCodeInList(methodInvocationTree, ERROR_CODES);
            if (catchParent != null && !isError) {
                StatusCodesOnResponseCheck.this.reportIssue((Tree)methodInvocationTree, StatusCodesOnResponseCheck.ISSUE_MESSAGE);
                return;
            }
            if (catchParent == null) {
                Tree tryParent = ExpressionUtils.getParentOfType((Tree)methodInvocationTree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
                boolean isOk = this.isCodeInList(methodInvocationTree, OK_CODES);
                if (tryParent != null && !isOk) {
                    StatusCodesOnResponseCheck.this.reportIssue((Tree)methodInvocationTree, StatusCodesOnResponseCheck.ISSUE_MESSAGE);
                }
            }
        }

        private boolean isCodeInList(MethodInvocationTree methodInvocationTree, List<String> codes) {
            ExpressionTree arg = (ExpressionTree)methodInvocationTree.arguments().get(0);
            if (arg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)arg;
                return codes.contains(memberSelectExpressionTree.identifier().name());
            }
            if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifierTree = (IdentifierTree)arg;
                return codes.contains(identifierTree.name());
            }
            return true;
        }

        private Tree checkCatch(MethodInvocationTree methodInvocationTree, boolean isError) {
            Tree catchParent = ExpressionUtils.getParentOfType((Tree)methodInvocationTree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CATCH});
            if (catchParent != null && !isError) {
                StatusCodesOnResponseCheck.this.reportIssue((Tree)methodInvocationTree, StatusCodesOnResponseCheck.ISSUE_MESSAGE);
            }
            return catchParent;
        }

        private Tree checkTry(MethodInvocationTree methodInvocationTree, boolean isOk) {
            Parents parents = StatusCodesOnResponseCheck.getParentsTryAndIf((Tree)methodInvocationTree);
            if (!parents.foundIfWithinTry() && parents.foundTryStatement && !isOk) {
                StatusCodesOnResponseCheck.this.reportIssue((Tree)methodInvocationTree, StatusCodesOnResponseCheck.ISSUE_MESSAGE);
            }
            return null;
        }
    }

    private static class Parents {
        boolean foundIfStatement;
        boolean foundTryStatement;

        public Parents(boolean foundIfStatement, boolean foundTryStatement) {
            this.foundIfStatement = foundIfStatement;
            this.foundTryStatement = foundTryStatement;
        }

        boolean foundIfWithinTry() {
            return this.foundIfStatement && this.foundTryStatement;
        }
    }
}

