/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4602")
public class SpringScanDefaultPackageCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_ATTRIBUTE = "value";
    private static final Map<String, Set<String>> SCAN_PACKAGE_ATTRIBUTES = SpringScanDefaultPackageCheck.buildScanPackageAttributes();

    private static Map<String, Set<String>> buildScanPackageAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("org.springframework.context.annotation.ComponentScan", new HashSet<String>(Arrays.asList(DEFAULT_ATTRIBUTE, "basePackages", "basePackageClasses")));
        map.put("org.springframework.boot.autoconfigure.SpringBootApplication", new HashSet<String>(Arrays.asList("scanBasePackages", "scanBasePackageClasses")));
        map.put("org.springframework.boot.web.servlet.ServletComponentScan", new HashSet<String>(Arrays.asList(DEFAULT_ATTRIBUTE, "basePackages", "basePackageClasses")));
        return map;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotation = (AnnotationTree)tree;
        Set<String> scanPackageAttributeNames = SCAN_PACKAGE_ATTRIBUTES.get(annotation.symbolType().fullyQualifiedName());
        if (scanPackageAttributeNames != null) {
            List<ExpressionTree> scanPackageAttributeValues = annotation.arguments().stream().filter(argument -> scanPackageAttributeNames.contains(SpringScanDefaultPackageCheck.attributeName(argument))).flatMap(SpringScanDefaultPackageCheck::extractValues).toList();
            this.checkAnnotationPackageAttributes(annotation, scanPackageAttributeValues);
        }
    }

    private void checkAnnotationPackageAttributes(AnnotationTree annotation, List<ExpressionTree> scanPackageAttributeValues) {
        if (scanPackageAttributeValues.isEmpty()) {
            if (SpringScanDefaultPackageCheck.isNodeInDefaultPackage((Tree)annotation)) {
                this.reportIssue((Tree)annotation.annotationType(), "Remove the annotation \"@" + annotation.symbolType().name() + "\" or move the annotated class out of the default package.");
            }
        } else {
            scanPackageAttributeValues.stream().map(SpringScanDefaultPackageCheck::findEmptyString).forEach(opt -> opt.ifPresent(expression -> this.reportIssue((Tree)expression, "Define packages to scan. Don't rely on the default package.")));
            scanPackageAttributeValues.stream().map(SpringScanDefaultPackageCheck::findClassInDefaultPackage).forEach(opt -> opt.ifPresent(identifier -> this.reportIssue((Tree)identifier, "Remove the annotation \"@" + annotation.symbolType().name() + "\" or move the \"" + identifier.name() + "\" class out of the default package.")));
        }
    }

    private static String attributeName(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
            return ((IdentifierTree)assignment.variable()).name();
        }
        return DEFAULT_ATTRIBUTE;
    }

    private static Stream<ExpressionTree> extractValues(ExpressionTree argument) {
        ExpressionTree expression = argument;
        if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            expression = ((AssignmentExpressionTree)expression).expression();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return ((NewArrayTree)expression).initializers().stream().flatMap(SpringScanDefaultPackageCheck::extractValues);
        }
        return Stream.of(expression);
    }

    private static Optional<ExpressionTree> findEmptyString(ExpressionTree expression) {
        return expression.asConstant(String.class).filter(String::isEmpty).map(s -> expression);
    }

    private static Optional<IdentifierTree> findClassInDefaultPackage(ExpressionTree expression) {
        IdentifierTree identifier;
        MemberSelectExpressionTree memberSelect;
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "class".equals((memberSelect = (MemberSelectExpressionTree)expression).identifier().name()) && memberSelect.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && SpringScanDefaultPackageCheck.isTypeInDefaultPackage((identifier = (IdentifierTree)memberSelect.expression()).symbol())) {
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    private static boolean isTypeInDefaultPackage(Symbol symbol) {
        if (!symbol.isTypeSymbol()) {
            return false;
        }
        Symbol parent = symbol.owner();
        while (!parent.isPackageSymbol()) {
            parent = parent.owner();
        }
        return parent.name().isEmpty();
    }

    private static boolean isNodeInDefaultPackage(Tree tree) {
        while (!tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            tree = tree.parent();
        }
        return ((CompilationUnitTree)tree).packageDeclaration() == null;
    }
}

