/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4601")
public class SpringAntMatcherOrderCheck
extends AbstractMethodDetection {
    private static final Pattern MATCHER_SPECIAL_CHAR = Pattern.compile("[?*{]");
    private static final MethodMatchers ANT_MATCHERS = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry"}).names(new String[]{"antMatchers"}).addParametersMatcher(new String[]{"java.lang.String[]"}).build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.config.annotation.web.builders.HttpSecurity"}).names(new String[]{"authorizeRequests"}).withAnyParameters().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree method) {
        List<StringConstant> antPatterns = SpringAntMatcherOrderCheck.collectAntPatterns(method);
        for (int indexToCheck = 1; indexToCheck < antPatterns.size(); ++indexToCheck) {
            this.checkAntPatternAt(antPatterns, indexToCheck);
        }
    }

    private void checkAntPatternAt(List<StringConstant> antPatterns, int indexToCheck) {
        StringConstant patternToCheck = antPatterns.get(indexToCheck);
        StringConstant incompatiblePattern = SpringAntMatcherOrderCheck.firstIncompatiblePreviousPattern(patternToCheck, antPatterns, indexToCheck);
        if (incompatiblePattern != null) {
            List<JavaFileScannerContext.Location> secondary = Collections.singletonList(new JavaFileScannerContext.Location("Less restrictive", (Tree)incompatiblePattern.expression));
            this.reportIssue((Tree)patternToCheck.expression, "Reorder the URL patterns from most to less specific, the pattern \"" + patternToCheck.value + "\" should occurs before \"" + incompatiblePattern.value + "\".", secondary, null);
        }
    }

    @CheckForNull
    private static StringConstant firstIncompatiblePreviousPattern(StringConstant patternToCheck, List<StringConstant> antPatterns, int antPatternsSize) {
        for (int i = 0; i < antPatternsSize; ++i) {
            StringConstant previousPattern = antPatterns.get(i);
            if (!SpringAntMatcherOrderCheck.matches(previousPattern.value, patternToCheck.value)) continue;
            return previousPattern;
        }
        return null;
    }

    private static List<StringConstant> collectAntPatterns(MethodInvocationTree method) {
        ArrayList<StringConstant> antPatterns = new ArrayList<StringConstant>();
        Optional<MethodInvocationTree> parentMethod = MethodTreeUtils.consecutiveMethodInvocation((Tree)method);
        while (parentMethod.isPresent()) {
            if (ANT_MATCHERS.matches(parentMethod.get())) {
                antPatterns.addAll(SpringAntMatcherOrderCheck.antMatchersPatterns(parentMethod.get()));
            }
            parentMethod = MethodTreeUtils.consecutiveMethodInvocation((Tree)parentMethod.get());
        }
        return antPatterns;
    }

    @VisibleForTesting
    static boolean matches(String pattern, String text) {
        if (pattern.equals(text)) {
            return true;
        }
        if (pattern.endsWith("**") && text.startsWith(pattern.substring(0, pattern.length() - 2))) {
            return true;
        }
        boolean antPatternContainsRegExp = pattern.contains("{");
        boolean textIsAlsoAnAntPattern = MATCHER_SPECIAL_CHAR.matcher(text).find();
        if (pattern.isEmpty() || antPatternContainsRegExp || textIsAlsoAnAntPattern) {
            return false;
        }
        return text.matches(SpringAntMatcherOrderCheck.antMatcherToRegEx(pattern));
    }

    @VisibleForTesting
    static String antMatcherToRegEx(String pattern) {
        return SpringAntMatcherOrderCheck.escapeRegExpChars(pattern).replace("?", "[^/]").replace("**", "$$").replace("*", "[^/]*").replace("$$", ".*");
    }

    @VisibleForTesting
    static String escapeRegExpChars(String pattern) {
        return pattern.replaceAll("([.(){}+|^$\\[\\]\\\\])", "\\\\$1");
    }

    private static List<StringConstant> antMatchersPatterns(MethodInvocationTree mit) {
        return mit.arguments().stream().map(StringConstant::of).filter(Objects::nonNull).toList();
    }

    private static class StringConstant {
        private final ExpressionTree expression;
        private final String value;

        private StringConstant(ExpressionTree expression, String value) {
            this.expression = expression;
            this.value = value;
        }

        @CheckForNull
        private static StringConstant of(ExpressionTree expression) {
            String value = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)expression).value();
            if (value != null) {
                return new StringConstant(expression, value);
            }
            return null;
        }
    }
}

