/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6831")
public class AvoidQualifierOnBeanMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final String BEAN_ANNOTATION = "org.springframework.context.annotation.Bean";
    private static final String QUALIFIER_ANNOTATION = "org.springframework.beans.factory.annotation.Qualifier";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        AnnotationTree beanAnnotation = AvoidQualifierOnBeanMethodsCheck.getAnnotation(methodTree, BEAN_ANNOTATION);
        AnnotationTree qualifierAnnotation = AvoidQualifierOnBeanMethodsCheck.getAnnotation(methodTree, QUALIFIER_ANNOTATION);
        if (beanAnnotation != null && qualifierAnnotation != null) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)qualifierAnnotation).withMessage("Remove this redundant \"@Qualifier\" annotation and rely on the @Bean method.").withQuickFixes(() -> AvoidQualifierOnBeanMethodsCheck.getQuickFix(methodTree, qualifierAnnotation)).report();
        }
    }

    private static AnnotationTree getAnnotation(MethodTree methodTree, String annotation) {
        return methodTree.modifiers().annotations().stream().filter(annotationTree -> annotationTree.symbolType().is(annotation)).findFirst().orElse(null);
    }

    private static List<JavaQuickFix> getQuickFix(MethodTree methodTree, AnnotationTree qualifierAnnotation) {
        LinkedList<JavaQuickFix> quickFixes = new LinkedList<JavaQuickFix>();
        if (AvoidQualifierOnBeanMethodsCheck.isFixable(methodTree, qualifierAnnotation)) {
            JavaQuickFix quickFix = JavaQuickFix.newQuickFix((String)"Remove \"@Qualifier\"").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)qualifierAnnotation)}).build();
            quickFixes.add(quickFix);
        }
        return quickFixes;
    }

    private static boolean isFixable(MethodTree methodTree, AnnotationTree qualifierAnnotation) {
        Arguments arguments = qualifierAnnotation.arguments();
        if (arguments.isEmpty()) {
            return true;
        }
        String methodName = methodTree.simpleName().name();
        return AvoidQualifierOnBeanMethodsCheck.getQualifierAnnotationValue(arguments).equals(methodName);
    }

    private static String getQualifierAnnotationValue(Arguments arguments) {
        ExpressionTree argument = (ExpressionTree)arguments.get(0);
        String qualifierAnnotationValue = argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) ? ((LiteralTreeImpl)((AssignmentExpressionTreeImpl)argument).expression()).value() : (argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? ((LiteralTreeImpl)argument).token().text() : "");
        return AvoidQualifierOnBeanMethodsCheck.removeQuotes(qualifierAnnotationValue);
    }

    private static String removeQuotes(String value) {
        return value.replace("\"", "");
    }
}

