/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6829")
public class AutowiredOnConstructorWhenMultipleConstructorsCheck
extends IssuableSubscriptionVisitor {
    private final List<String> annotations = List.of("org.springframework.context.annotation.Bean", "org.springframework.context.annotation.Configuration", "org.springframework.stereotype.Component", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Service");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        boolean anyHasAutowired;
        ClassTree classTree = (ClassTree)tree;
        boolean isSpringClass = classTree.modifiers().annotations().stream().anyMatch(annotation -> this.annotations.contains(annotation.symbolType().fullyQualifiedName()));
        if (!isSpringClass) {
            return;
        }
        List<MethodTree> constructors = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(MethodTree.class::cast).toList();
        if (constructors.size() > 1 && !(anyHasAutowired = constructors.stream().anyMatch(constructor -> constructor.modifiers().annotations().stream().anyMatch(annotation -> annotation.symbolType().is("org.springframework.beans.factory.annotation.Autowired"))))) {
            this.reportIssue((Tree)classTree.simpleName(), "Add @Autowired to one of the constructors.");
        }
    }
}

