/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6817")
public class AsyncMethodsOnConfigurationClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        boolean isConfiguration = classTree.modifiers().annotations().stream().anyMatch(annotation -> annotation.annotationType().symbolType().is("org.springframework.context.annotation.Configuration"));
        if (isConfiguration) {
            classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).forEach(member -> member.modifiers().annotations().stream().filter(annotation -> annotation.annotationType().symbolType().is("org.springframework.scheduling.annotation.Async")).findFirst().ifPresent(annotation -> QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)annotation).withMessage("Remove this \"@Async\" annotation from this method.").withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove \"@Async\"").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)annotation)}).build()).report()));
        }
    }
}

