/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2060")
public class ExternalizableClassConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ExternalizableClassConstructorCheck.isAnonymous(classTree) && ExternalizableClassConstructorCheck.implementsExternalizable(classTree)) {
            Tree declaration;
            Collection constructors = classTree.symbol().lookupSymbols("<init>");
            Optional<Symbol> noArgConstructor = constructors.stream().filter(ExternalizableClassConstructorCheck::isNoArgConstructor).findFirst();
            if (noArgConstructor.isEmpty()) {
                this.reportIssue((Tree)Objects.requireNonNull(classTree.simpleName()), "Add a no-arg constructor to this class.");
            } else if (!noArgConstructor.get().isPublic() && (declaration = noArgConstructor.get().declaration()) != null) {
                this.reportIssue((Tree)((MethodTree)declaration).simpleName(), "Declare this no-arg constructor public.");
            }
        }
    }

    private static boolean isAnonymous(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private static boolean implementsExternalizable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Externalizable");
    }

    private static boolean isNoArgConstructor(Symbol constructor) {
        return ((Symbol.MethodSymbol)constructor).parameterTypes().isEmpty();
    }
}

