/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4926")
public class BlindSerialVersionUidCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
        if (BlindSerialVersionUidCheck.isSerializable(symbol.type())) {
            BlindSerialVersionUidCheck.findSerialVersionUid(symbol).filter(BlindSerialVersionUidCheck::isValidSerialVersionUid).map(serialVersionUidSymbol -> serialVersionUidSymbol.declaration().simpleName()).ifPresent(declarationTree -> this.reportIssue((Tree)declarationTree, "Remove this \"serialVersionUID\"."));
        }
    }

    private static Optional<Symbol.VariableSymbol> findSerialVersionUid(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("serialVersionUID").stream().filter(Symbol::isVariableSymbol).map(Symbol.VariableSymbol.class::cast).findFirst();
    }

    private static boolean isValidSerialVersionUid(Symbol.VariableSymbol serialVersionUidSymbol) {
        return serialVersionUidSymbol.isStatic() && serialVersionUidSymbol.isFinal() && serialVersionUidSymbol.type().isPrimitive(Type.Primitives.LONG);
    }

    private static boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }
}

