/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4434")
public class LDAPDeserializationCheck
extends AbstractMethodDetection {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CLASS_NAME = "javax.naming.directory.SearchControls";
    private static final int RET_OBJ_INDEX = 4;

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{CLASS_NAME}).names(new String[]{CONSTRUCTOR_NAME}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{CLASS_NAME}).names(new String[]{"setReturningObjFlag"}).addParametersMatcher(new String[]{"boolean"}).build()});
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkConstructorArguments(newClassTree.arguments());
    }

    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        if (CONSTRUCTOR_NAME.equals(methodTree.methodSymbol().name())) {
            this.checkConstructorArguments(methodTree.arguments());
        } else {
            ExpressionTree setValue = (ExpressionTree)methodTree.arguments().get(0);
            this.reportIfTrue(setValue);
        }
    }

    private void checkConstructorArguments(Arguments args) {
        if (args.size() <= 4) {
            return;
        }
        ExpressionTree retObjArgument = (ExpressionTree)args.get(4);
        this.reportIfTrue(retObjArgument);
    }

    private void reportIfTrue(ExpressionTree toUnderline) {
        if (LiteralUtils.isTrue((Tree)toUnderline)) {
            this.reportIssue((Tree)toUnderline, "Disable object deserialization.");
        }
    }
}

