/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5659")
public class JWTWithStrongCipherCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_STRONG_CIPHER = "Use only strong cipher algorithms when %s this JWT.";
    private static final String AUTH0_JWT_ALGORITHM = "com.auth0.jwt.algorithms.Algorithm";
    private static final MethodMatchers AUTH0_JWT_REQUIRE = MethodMatchers.create().ofTypes(new String[]{"com.auth0.jwt.JWT"}).names(new String[]{"require"}).addParametersMatcher(new String[]{"com.auth0.jwt.algorithms.Algorithm"}).build();
    private static final MethodMatchers AUTH0_JWT_SIGN = MethodMatchers.create().ofTypes(new String[]{"com.auth0.jwt.JWTCreator$Builder"}).names(new String[]{"sign"}).addParametersMatcher(new String[]{"com.auth0.jwt.algorithms.Algorithm"}).build();
    private static final MethodMatchers ALGORITHM_NONE = MethodMatchers.create().ofTypes(new String[]{"com.auth0.jwt.algorithms.Algorithm"}).names(new String[]{"none"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers JWTK_JJWT_PARSE = MethodMatchers.create().ofTypes(new String[]{"io.jsonwebtoken.JwtParser"}).names(new String[]{"parse"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final MethodMatchers JWTK_JJWT_COMPACT = MethodMatchers.create().ofTypes(new String[]{"io.jsonwebtoken.JwtBuilder"}).names(new String[]{"compact"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers JWTK_JJWT_BUILDER = MethodMatchers.create().ofTypes(new String[]{"io.jsonwebtoken.Jwts"}).names(new String[]{"builder"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers JWTK_JJWT_SIGN_WITH = MethodMatchers.create().ofTypes(new String[]{"io.jsonwebtoken.JwtBuilder"}).names(new String[]{"signWith"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        this.handleAuth0Jwt(mit);
        this.handleJwtkJwt(mit);
    }

    private void handleAuth0Jwt(MethodInvocationTree mit) {
        if (AUTH0_JWT_REQUIRE.matches(mit)) {
            this.reportIfAlgorithmIsNone((ExpressionTree)mit.arguments().get(0), "verifying the signature of");
        } else if (AUTH0_JWT_SIGN.matches(mit)) {
            this.reportIfAlgorithmIsNone((ExpressionTree)mit.arguments().get(0), "signing");
        }
    }

    private void reportIfAlgorithmIsNone(ExpressionTree expressionTree, String action) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ALGORITHM_NONE.matches((MethodInvocationTree)expressionTree)) {
            this.reportIssue((Tree)expressionTree, String.format(MESSAGE_STRONG_CIPHER, action));
        }
    }

    private void handleJwtkJwt(MethodInvocationTree mit) {
        if (JWTK_JJWT_PARSE.matches(mit)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "The JWT signature (JWS) should be verified before using this token.");
        } else if (JWTK_JJWT_COMPACT.matches(mit) && !JWTWithStrongCipherCheck.isSigned(mit)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Sign this token using a strong cipher algorithm.");
        }
    }

    private static boolean isSigned(MethodInvocationTree mit) {
        if (JWTK_JJWT_SIGN_WITH.matches(mit)) {
            return true;
        }
        if (JWTK_JJWT_BUILDER.matches(mit)) {
            return false;
        }
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return JWTWithStrongCipherCheck.isSigned((MethodInvocationTree)expression);
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)expression).symbol();
                return symbol.usages().stream().anyMatch(JWTWithStrongCipherCheck::canSignToken) || JWTWithStrongCipherCheck.declarationIsSigned(symbol);
            }
        }
        return true;
    }

    private static boolean canSignToken(IdentifierTree tokenIdentifier) {
        Tree parent = tokenIdentifier.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS}) || MethodTreeUtils.subsequentMethodInvocation((Tree)tokenIdentifier, JWTK_JJWT_SIGN_WITH).isPresent();
    }

    private static boolean declarationIsSigned(Symbol symbol) {
        Tree declaration;
        if (symbol.isLocalVariable() && (declaration = symbol.declaration()) instanceof VariableTree) {
            MethodInvocationTree methodInvocationTree;
            VariableTree variableTree = (VariableTree)declaration;
            ExpressionTree initializer = variableTree.initializer();
            return initializer instanceof MethodInvocationTree && JWTWithStrongCipherCheck.isSigned(methodInvocationTree = (MethodInvocationTree)initializer);
        }
        return true;
    }
}

