/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5808")
public class AuthorizationsStrongDecisionsCheck
extends IssuableSubscriptionVisitor {
    private static final String AUTHENTICATION = "org.springframework.security.core.Authentication";
    private static final String JAVA_OBJECT = "java.lang.Object";
    private static final MethodMatchers ACCESS_DECISION_VOTER_VOTE = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.access.AccessDecisionVoter"}).names(new String[]{"vote"}).addParametersMatcher(new String[]{"org.springframework.security.core.Authentication", "java.lang.Object", "java.util.Collection"}).build();
    private static final MethodMatchers PERMISSION_EVALUATOR_HAS_PERMISSION = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.access.PermissionEvaluator"}).names(new String[]{"hasPermission"}).addParametersMatcher(new String[]{"org.springframework.security.core.Authentication", "java.lang.Object", "java.lang.Object"}).addParametersMatcher(new String[]{"org.springframework.security.core.Authentication", "java.io.Serializable", "java.lang.String", "java.lang.Object"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ACCESS_DECISION_VOTER_VOTE.matches(methodTree)) {
            this.reportNoStrongDecision(methodTree, AuthorizationsStrongDecisionsCheck::isStrongVoteDecision, "vote", "ACCESS_DENIED");
        } else if (PERMISSION_EVALUATOR_HAS_PERMISSION.matches(methodTree)) {
            this.reportNoStrongDecision(methodTree, AuthorizationsStrongDecisionsCheck::isStrongHasPermissionDecision, "hasPermission", "false");
        }
    }

    private void reportNoStrongDecision(MethodTree methodTree, Predicate<ExpressionTree> isStrongDecision, String methodName, String strongDecision) {
        ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor(isStrongDecision);
        methodTree.accept((TreeVisitor)returnStatementVisitor);
        if (!returnStatementVisitor.takesStrongDecision()) {
            this.reportIssue((Tree)methodTree.simpleName(), String.format("\"%s\" method should return at least one time %s.", methodName, strongDecision));
        }
    }

    private static boolean isStrongVoteDecision(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            expression = ((MemberSelectExpressionTree)expression).identifier();
        }
        if (expression instanceof LiteralTree || expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            return false;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            String name = ((IdentifierTree)expression).name();
            if ("ACCESS_DENIED".equals(name)) {
                return true;
            }
            if ("ACCESS_GRANTED".equals(name) || "ACCESS_ABSTAIN".equals(name)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isStrongHasPermissionDecision(ExpressionTree expression) {
        if (expression instanceof LiteralTree) {
            return expression.asConstant(Boolean.class).filter(Boolean.FALSE::equals).isPresent();
        }
        return true;
    }

    private static class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private final Predicate<ExpressionTree> isStrongDecision;
        private boolean takesStrongDecision = false;

        ReturnStatementVisitor(Predicate<ExpressionTree> isStrongDecision) {
            this.isStrongDecision = isStrongDecision;
        }

        public boolean takesStrongDecision() {
            return this.takesStrongDecision;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            ExpressionTree expression = tree.expression();
            if (expression != null && this.isStrongDecision.test(expression)) {
                this.takesStrongDecision = true;
            }
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            this.takesStrongDecision = true;
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

