/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.design;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.design.AbstractCouplingChecker;
import org.sonar.java.checks.helpers.ClassPatternsUtils;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6539")
public class ClassImportCouplingCheck
extends AbstractCouplingChecker {
    private static final int COUPLING_THRESHOLD = 20;
    @RuleProperty(key="couplingThreshold", description="Maximum number of classes a single class is allowed to depend upon. This value is an experimental value.", defaultValue="20")
    public int couplingThreshold = 20;
    private String packageName;
    private Set<Tree> imports;
    private Set<Tree> secondaryLocations;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.imports = null;
        this.secondaryLocations = null;
    }

    public void visitClass(ClassTree tree) {
        if (ClassPatternsUtils.isUtilityClass(tree) || ClassPatternsUtils.isPrivateInnerClass(tree)) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            this.nesting.push(this.types);
            this.types = new HashSet();
        }
        CompilationUnitTree compilationUnitTree = (CompilationUnitTree)ExpressionUtils.getParentOfType((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT});
        this.packageName = JavaTree.PackageDeclarationTreeImpl.packageNameAsString((PackageDeclarationTree)compilationUnitTree.packageDeclaration());
        if (this.imports == null) {
            String fileProjectName = this.context.getProject().key();
            this.imports = compilationUnitTree.imports().stream().filter(i -> !i.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})).map(ImportTree.class::cast).map(ImportTree::qualifiedIdentifier).filter(i -> ExpressionsHelper.concatenate((ExpressionTree)((ExpressionTree)i)).startsWith(fileProjectName)).collect(Collectors.toSet());
            this.secondaryLocations = new HashSet<Tree>();
            this.secondaryLocations.addAll(this.imports);
        }
        this.checkTypes((Tree)tree.superClass(), this.types);
        this.checkTypes((List<? extends Tree>)tree.superInterfaces());
        super.visitClass(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.simpleName() != null) {
            int size = this.imports.size() + this.types.size();
            if (size > this.couplingThreshold) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Split this \u201cMonster Class\u201d into smaller and more specialized ones to reduce its dependencies on other classes from " + size + " to the maximum authorized " + this.couplingThreshold + " or less.", this.getSecondaryLocations(), null);
            }
            this.types = (Set)this.nesting.pop();
        }
    }

    private List<JavaFileScannerContext.Location> getSecondaryLocations() {
        return this.secondaryLocations.stream().map(element -> new JavaFileScannerContext.Location("This class contributes to the tight class coupling.", element)).toList();
    }

    @Override
    public void checkTypes(@Nullable Tree type, @Nullable Set<String> types) {
        MemberSelectExpressionTree memberSelect;
        String name;
        if (type == null || types == null) {
            return;
        }
        if (type.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTreeImpl identifierTree = (IdentifierTreeImpl)type;
            String fullyQualifiedName = identifierTree.symbolType().fullyQualifiedName();
            if (fullyQualifiedName.contains(this.packageName)) {
                types.add(fullyQualifiedName);
                this.secondaryLocations.add(type);
            }
        } else if (type.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (name = ExpressionsHelper.concatenate((ExpressionTree)(memberSelect = (MemberSelectExpressionTree)type))).contains(this.packageName)) {
            types.add(name);
            this.secondaryLocations.add(type);
        }
    }
}

