/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.metrics.MetricsComputer;
import org.sonar.java.metrics.MetricsScannerContext;
import org.sonar.java.model.DefaultModuleScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.ModuleScannerContext;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6541")
public class BrainMethodCheck
extends IssuableSubscriptionVisitor
implements EndOfAnalysis {
    private static final String ISSUE_MESSAGE = "A \"Brain Method\" was detected. Refactor it to reduce at least one of the following metrics: LOC from %d to %d, Complexity from %d to %d, Nesting Level from %d to %d, Number of Variables from %d to %d.";
    private static final int DEFAULT_LOC_THRESHOLD = 65;
    private static final int DEFAULT_CYCLO_THRESHOLD = 15;
    private static final int DEFAULT_NESTING_THRESHOLD = 3;
    private static final int DEFAULT_VARIABLES_THRESHOLD = 7;
    @RuleProperty(key="locThreshold", description="The maximum number of LOC allowed.", defaultValue="65")
    public int locThreshold = 65;
    @RuleProperty(key="cyclomaticThreshold", description="The maximum cyclomatic complexity allowed.", defaultValue="15")
    public int cyclomaticThreshold = 15;
    @RuleProperty(key="nestingThreshold", description="The maximum nesting level allowed.", defaultValue="3")
    public int nestingThreshold = 3;
    @RuleProperty(key="noavThreshold", description="The maximum number of accessed variables allowed.", defaultValue="7")
    public int noavThreshold = 7;
    @VisibleForTesting
    int numberOfIssuesToReport = 10;
    private final List<IssueFound> issuesFound = new ArrayList<IssueFound>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        MetricsComputer metricsComputer = ((MetricsScannerContext)this.context).getMetricsComputer();
        if (BrainMethodCheck.isExcluded(methodTree)) {
            return;
        }
        int cyclomaticComplexity = metricsComputer.getComplexityNodes((Tree)methodTree).size();
        int maxNestingLevel = metricsComputer.getMethodNestingLevel(methodTree);
        int linesOfCode = metricsComputer.getLinesOfCode((Tree)methodTree.block());
        int numberOfAccessedVariables = metricsComputer.getNumberOfAccessedVariables(methodTree);
        if (linesOfCode >= this.locThreshold && cyclomaticComplexity >= this.cyclomaticThreshold && maxNestingLevel >= this.nestingThreshold && numberOfAccessedVariables >= this.noavThreshold) {
            int brainScore = numberOfAccessedVariables + cyclomaticComplexity + maxNestingLevel * linesOfCode;
            String issueMessage = String.format(ISSUE_MESSAGE, linesOfCode, this.locThreshold - 1, cyclomaticComplexity, this.cyclomaticThreshold - 1, maxNestingLevel, this.nestingThreshold - 1, numberOfAccessedVariables, this.noavThreshold - 1);
            AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)this, (InputComponent)this.context.getInputFile(), AnalyzerMessage.textSpanFor((Tree)methodTree.simpleName()), issueMessage, 0);
            this.issuesFound.add(new IssueFound(brainScore, analyzerMessage));
        }
    }

    private static boolean isExcluded(MethodTree methodTree) {
        return methodTree.symbol().isAbstract() || methodTree.block() == null || MethodTreeUtils.isEqualsMethod(methodTree) || MethodTreeUtils.isHashCodeMethod(methodTree);
    }

    public void endOfAnalysis(ModuleScannerContext context) {
        if (this.issuesFound.size() > this.numberOfIssuesToReport) {
            this.numberOfIssuesToReport += this.issuesFound.size() / 10;
            this.issuesFound.sort((a, b) -> b.brainScore - a.brainScore);
        } else {
            this.numberOfIssuesToReport = this.issuesFound.size();
        }
        DefaultModuleScannerContext defaultContext = (DefaultModuleScannerContext)context;
        for (int i = 0; i < this.numberOfIssuesToReport; ++i) {
            IssueFound issueFound = this.issuesFound.get(i);
            defaultContext.reportIssue(issueFound.analyzerMessage);
        }
    }

    private static class IssueFound {
        int brainScore;
        AnalyzerMessage analyzerMessage;

        public IssueFound(int brainScore, AnalyzerMessage analyzerMessage) {
            this.brainScore = brainScore;
            this.analyzerMessage = analyzerMessage;
        }
    }
}

