/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.design;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public abstract class AbstractCouplingChecker
extends BaseTreeVisitor
implements JavaFileScanner {
    protected final Deque<Set<String>> nesting = new LinkedList<Set<String>>();
    protected Set<String> types;
    protected JavaFileScannerContext context;

    abstract void checkTypes(@Nullable Tree var1, @Nullable Set<String> var2);

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        super.visitVariable(tree);
    }

    public void visitCatch(CatchTree tree) {
        this.scan((Tree)tree.block());
    }

    public void visitTypeCast(TypeCastTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        super.visitTypeCast(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.checkTypes((Tree)tree.returnType(), this.types);
        super.visitMethod(tree);
    }

    public void visitTypeParameter(TypeParameterTree typeParameter) {
        this.checkTypes((List<? extends Tree>)typeParameter.bounds());
        this.checkTypes((Tree)typeParameter.identifier(), this.types);
        super.visitTypeParameter(typeParameter);
    }

    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        this.checkTypes((List<? extends Tree>)tree.typeArguments());
        super.visitParameterizedType(tree);
    }

    public void visitNewClass(NewClassTree tree) {
        if (tree.typeArguments() != null) {
            this.checkTypes((List<? extends Tree>)tree.typeArguments());
        }
        if (tree.identifier().is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            this.scan((Tree)tree.enclosingExpression());
            this.checkTypes((List<? extends Tree>)((ParameterizedTypeTree)tree.identifier()).typeArguments());
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
            this.scan((Tree)tree.classBody());
        } else {
            super.visitNewClass(tree);
        }
    }

    public void visitWildcard(WildcardTree tree) {
        this.checkTypes((Tree)tree.bound(), this.types);
        super.visitWildcard(tree);
    }

    public void visitArrayType(ArrayTypeTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        super.visitArrayType(tree);
    }

    public void visitInstanceOf(InstanceOfTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        super.visitInstanceOf(tree);
    }

    public void visitNewArray(NewArrayTree tree) {
        this.checkTypes((Tree)tree.type(), this.types);
        super.visitNewArray(tree);
    }

    protected void checkTypes(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.checkTypes(tree, this.types);
        }
    }
}

