/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4423")
public class WeakSSLContextCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Change this code to use a stronger protocol.";
    private static final String SECONDARY_LOCATION_MESSAGE = "Other weak protocol.";
    private static final Set<String> STRONG_PROTOCOLS = new HashSet<String>(Arrays.asList("TLSv1.2", "DTLSv1.2", "TLSv1.3", "DTLSv1.3"));
    private static final Set<String> STRONG_AFTER_JAVA_8 = new HashSet<String>(Arrays.asList("TLS", "DTLS"));
    private static final Set<String> WEAK_FOR_OK_HTTP = new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLS_1_0", "TLS_1_1"));
    private static final Set<String> WEAK_FOR_SET_ENABLED_PROTOCOLS = new HashSet<String>(Set.of("TLSv1.0", "TLSv1.1"));
    private static final MethodMatchers SSLCONTEXT_GETINSTANCE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"javax.net.ssl.SSLContext"}).names(new String[]{"getInstance"}).withAnyParameters().build();
    private static final MethodMatchers OK_HTTP_TLS_VERSION = MethodMatchers.create().ofTypes(new String[]{"okhttp3.ConnectionSpec$Builder"}).names(new String[]{"tlsVersions"}).withAnyParameters().build();
    private static final MethodMatchers OPTIONS_ENABLED_PROTOCOLS = MethodMatchers.create().ofTypes(new String[]{"org.springframework.boot.autoconfigure.ssl.SslBundleProperties$Options"}).names(new String[]{"setEnabledProtocols"}).addParametersMatcher(new String[]{"java.util.Set"}).build();
    private boolean javaVersionNotSetOr8OrHigher;

    public void setContext(JavaFileScannerContext context) {
        this.javaVersionNotSetOr8OrHigher = context.getJavaVersion().isJava8Compatible();
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree methodInvocation;
        List<JavaFileScannerContext.Location> secondaryLocations;
        ExpressionTree argument;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        Arguments arguments = mit.arguments();
        if (SSLCONTEXT_GETINSTANCE_MATCHER.matches(mit)) {
            ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
            firstArgument.asConstant(String.class).ifPresent(protocol -> {
                if (!this.isStrongProtocol((String)protocol)) {
                    this.reportIssue((Tree)firstArgument, ISSUE_MESSAGE);
                }
            });
        } else if (OK_HTTP_TLS_VERSION.matches(mit)) {
            List<ExpressionTree> unsecureVersions = WeakSSLContextCheck.getUnsecureVersionsInArguments(arguments);
            if (!unsecureVersions.isEmpty()) {
                List<JavaFileScannerContext.Location> secondaries = unsecureVersions.stream().skip(1L).map(secondary -> new JavaFileScannerContext.Location(SECONDARY_LOCATION_MESSAGE, (Tree)secondary)).toList();
                this.reportIssue((Tree)unsecureVersions.get(0), ISSUE_MESSAGE, secondaries, null);
            }
        } else if (OPTIONS_ENABLED_PROTOCOLS.matches(mit) && (argument = (ExpressionTree)arguments.get(0)) instanceof MethodInvocationTree && !(secondaryLocations = (methodInvocation = (MethodInvocationTree)argument).arguments().stream().filter(arg -> {
            Object argValue = ExpressionUtils.resolveAsConstant((ExpressionTree)arg);
            return argValue != null && WEAK_FOR_SET_ENABLED_PROTOCOLS.contains(argValue);
        }).map(arg -> new JavaFileScannerContext.Location(SECONDARY_LOCATION_MESSAGE, (Tree)arg)).toList()).isEmpty()) {
            this.reportIssue((Tree)((MemberSelectExpressionTree)mit.methodSelect()).identifier(), ISSUE_MESSAGE, secondaryLocations, null);
        }
    }

    private boolean isStrongProtocol(String protocol) {
        return STRONG_PROTOCOLS.contains(protocol) || this.javaVersionNotSetOr8OrHigher && STRONG_AFTER_JAVA_8.contains(protocol);
    }

    private static List<ExpressionTree> getUnsecureVersionsInArguments(Arguments arguments) {
        return arguments.stream().filter(WeakSSLContextCheck::isUnsecureVersion).toList();
    }

    private static boolean isUnsecureVersion(ExpressionTree expressionTree) {
        String argumentValue = null;
        Optional stringArgument = expressionTree.asConstant(String.class);
        if (stringArgument.isPresent()) {
            argumentValue = (String)stringArgument.get();
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            argumentValue = ((IdentifierTree)expressionTree).name();
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            argumentValue = ((MemberSelectExpressionTree)expressionTree).identifier().name();
        }
        return WEAK_FOR_OK_HTTP.contains(argumentValue);
    }
}

