/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6212")
public class VarCanBeUsedCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public static final String MESSAGE = "Declare this local variable with \"var\" instead.";
    private int typeAssignmentLine = -1;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.VARIABLE);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava10Compatible();
    }

    public void setContext(JavaFileScannerContext context) {
        this.typeAssignmentLine = -1;
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        ExpressionTree initializer = variableTree.initializer();
        TypeTree type = variableTree.type();
        Type symbolType = type.symbolType();
        String typeName = symbolType.name().toLowerCase(Locale.ROOT);
        IdentifierTree identifierTree = variableTree.simpleName();
        if (this.isMultiAssignment(variableTree) || initializer == null || type.is(new Tree.Kind[]{Tree.Kind.VAR_TYPE}) || VarCanBeUsedCheck.isArrayInitializerWithoutType(initializer) || symbolType.isUnknown() || !variableTree.symbol().isLocalVariable() || symbolType.isParameterized()) {
            return;
        }
        if (VarCanBeUsedCheck.isExcludedInitializer(initializer = ExpressionUtils.skipParentheses((ExpressionTree)initializer))) {
            return;
        }
        Type initializerType = initializer.symbolType();
        if (symbolType.fullyQualifiedName().equals(initializerType.fullyQualifiedName()) && (VarCanBeUsedCheck.isSelfExplained(initializer) || VarCanBeUsedCheck.typeWasMentionedInTheName(identifierTree, typeName) || VarCanBeUsedCheck.typeWasMentionedInTheInitializer(initializer, typeName))) {
            this.reportIssue((Tree)identifierTree, MESSAGE);
        }
    }

    private static boolean isExcludedInitializer(ExpressionTree initializer) {
        if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol.MethodSymbol symbol = ((MethodInvocationTree)initializer).methodSymbol();
            return !symbol.isUnknown() && symbol.isParametrizedMethod();
        }
        return initializer.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.METHOD_REFERENCE, Tree.Kind.LAMBDA_EXPRESSION});
    }

    private static boolean typeWasMentionedInTheName(IdentifierTree variable, String type) {
        return VarCanBeUsedCheck.isLogicallyReferable(variable.name(), type);
    }

    private static boolean isSelfExplained(ExpressionTree initializer) {
        return initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY}) || initializer instanceof LiteralTree;
    }

    private static boolean typeWasMentionedInTheInitializer(ExpressionTree initializer, String type) {
        if (initializer.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && VarCanBeUsedCheck.typeWasMentionedInTheName((IdentifierTree)initializer, type)) {
            return true;
        }
        if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            ExpressionTree methodSelect = ExpressionUtils.skipParentheses((ExpressionTree)((MethodInvocationTree)initializer).methodSelect());
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && VarCanBeUsedCheck.typeWasMentionedInTheName((IdentifierTree)methodSelect, type)) {
                return true;
            }
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                return VarCanBeUsedCheck.typeWasMentionedInTheName(memberSelectExpressionTree.identifier(), type) || memberSelectExpressionTree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && VarCanBeUsedCheck.typeWasMentionedInTheName((IdentifierTree)memberSelectExpressionTree.expression(), type);
            }
        }
        return false;
    }

    private static boolean isLogicallyReferable(String identifierName, String typeName) {
        return identifierName.toLowerCase(Locale.ROOT).contains(typeName);
    }

    private boolean isMultiAssignment(VariableTree variableTree) {
        SyntaxToken firstToken = variableTree.type().firstToken();
        if (firstToken == null) {
            return false;
        }
        int line = LineUtils.startLine((SyntaxToken)firstToken);
        if (this.typeAssignmentLine == line) {
            return true;
        }
        this.typeAssignmentLine = line;
        SyntaxToken token = variableTree.endToken();
        return token != null && ",".equals(token.text());
    }

    private static boolean isArrayInitializerWithoutType(ExpressionTree initializer) {
        return initializer.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && ((NewArrayTree)initializer).newKeyword() == null;
    }
}

