/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S5665")
public class UnnecessaryEscapeSequencesInTextBlockCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove this unnecessary escape sequence.";
    private static final String TRIPLE_QUOTE_MESSAGE = "Use '\\\"\"\"' to escape \"\"\".";
    private static final Set<String> ESCAPED = SetUtils.immutableSetOf((Object[])new String[]{"\\n", "\\'", "\\\""});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TEXT_BLOCK);
    }

    public void visitNode(Tree tree) {
        LiteralTree textBlock = (LiteralTree)tree;
        int startLine = LineUtils.startLine((SyntaxToken)textBlock.token());
        String value = textBlock.value();
        String[] lines = value.split("\r?\n|\r");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = lines[i].replace("\\\\", "");
            if (lines[i].contains("\\\"\\\"\\\"")) {
                this.addIssue(startLine + i, TRIPLE_QUOTE_MESSAGE);
                continue;
            }
            String replaced = lines[i].replace("\\\"\"\"", "");
            if (!ESCAPED.stream().anyMatch(replaced::contains)) continue;
            this.addIssue(startLine + i, MESSAGE);
        }
    }
}

