/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1158")
public class ToStringUsingBoxingCheck
extends IssuableSubscriptionVisitor {
    private static final String[] PRIMITIVE_WRAPPERS = new String[]{"java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean"};
    private static final MethodMatchers PRIMITIVE_CONSTRUCTOR = MethodMatchers.create().ofTypes(PRIMITIVE_WRAPPERS).constructor().addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers PRIMITIVE_VALUE_OF = MethodMatchers.create().ofTypes(PRIMITIVE_WRAPPERS).names(new String[]{"valueOf"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers TO_STRING = MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).withAnyParameters().build();
    private static final MethodMatchers COMPARE_TO = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Comparable"}).names(new String[]{"compareTo"}).addParametersMatcher(new String[]{"*"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        ExpressionTree methodSelect = mit.methodSelect();
        if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return;
        }
        ExpressionTree memberSelectExpression = ((MemberSelectExpressionTree)methodSelect).expression();
        ToStringUsingBoxingCheck.getArgumentOfPrimitiveWrapper(memberSelectExpression).filter(arg -> arg.symbolType().isPrimitive()).ifPresent(arg -> this.reportIfCompareToOrToString(mit, memberSelectExpression, memberSelectExpression.symbolType().toString(), (Tree)arg));
    }

    private static Optional<ExpressionTree> getArgumentOfPrimitiveWrapper(ExpressionTree memberSelectExpression) {
        if (memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && PRIMITIVE_CONSTRUCTOR.matches((NewClassTree)memberSelectExpression)) {
            return Optional.of((ExpressionTree)((NewClassTree)memberSelectExpression).arguments().get(0));
        }
        if (memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && PRIMITIVE_VALUE_OF.matches((MethodInvocationTree)memberSelectExpression)) {
            return Optional.of((ExpressionTree)((MethodInvocationTree)memberSelectExpression).arguments().get(0));
        }
        return Optional.empty();
    }

    private void reportIfCompareToOrToString(MethodInvocationTree mit, ExpressionTree memberSelectExpression, String boxedType, Tree argument) {
        Supplier<JavaQuickFix> quickFix;
        String replacementMethod;
        if (TO_STRING.matches(mit)) {
            replacementMethod = "toString";
            quickFix = mit.arguments().isEmpty() ? ToStringUsingBoxingCheck.toStringQuickFix(mit, boxedType, argument) : ToStringUsingBoxingCheck.toStringWithArgumentQuickFix(memberSelectExpression, boxedType);
        } else if (COMPARE_TO.matches(mit)) {
            replacementMethod = "compare";
            quickFix = ToStringUsingBoxingCheck.compareToQuickFix(mit, boxedType, argument, (Tree)mit.arguments().get(0));
        } else {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)mit).withMessage(String.format("Call the static method %s.%s(...) instead of instantiating a temporary object.", boxedType, replacementMethod)).withQuickFix(quickFix).report();
    }

    private static Supplier<JavaQuickFix> toStringQuickFix(MethodInvocationTree mit, String boxedType, Tree argument) {
        String replacement = String.format("%s.toString(", boxedType);
        return () -> JavaQuickFix.newQuickFix((String)String.format("Use %s...) instead", replacement)).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)mit, (boolean)true, (Tree)argument, (boolean)false), (String)replacement), JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)argument, (boolean)false, (Tree)mit, (boolean)true), (String)")")}).build();
    }

    private static Supplier<JavaQuickFix> toStringWithArgumentQuickFix(ExpressionTree memberSelectExpression, String type) {
        return () -> JavaQuickFix.newQuickFix((String)String.format("Use %s.toString(...) instead", type)).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)memberSelectExpression, (String)type)}).build();
    }

    private static Supplier<JavaQuickFix> compareToQuickFix(MethodInvocationTree mit, String type, Tree firstArgument, Tree secondArgument) {
        String replacement = String.format("%s.compare(", type);
        return () -> JavaQuickFix.newQuickFix((String)String.format("Use %s...) instead", replacement)).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)mit, (boolean)true, (Tree)firstArgument, (boolean)false), (String)replacement), JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)firstArgument, (boolean)false, (Tree)secondArgument, (boolean)false), (String)", ")}).build();
    }
}

