/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S3020")
public class ToArrayCheck
extends AbstractMethodDetection {
    private static final MethodMatchers COLLECTION_TO_ARRAY = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"toArray"}).addWithoutParametersMatcher().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return COLLECTION_TO_ARRAY;
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            this.checkCast((TypeCastTree)parent, mit);
        }
    }

    private void checkCast(TypeCastTree castTree, MethodInvocationTree mit) {
        Type type = castTree.symbolType();
        if (type.isArray() && !type.is("java.lang.Object[]")) {
            Type elementType = ((Type.ArrayType)type).elementType();
            ExpressionTree methodSelect = mit.methodSelect();
            if (!elementType.isTypeVar() && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                String typeName = String.format("new %s[0]", elementType.name());
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)mit).withMessage("Pass \"%s\" as argument to \"toArray\".", new Object[]{typeName}).withQuickFix(() -> ToArrayCheck.getQuickFix(castTree, mit, (MemberSelectExpressionTree)methodSelect, typeName)).report();
            }
        }
    }

    private static JavaQuickFix getQuickFix(TypeCastTree castTree, MethodInvocationTree mit, MemberSelectExpressionTree methodSelect, String typeName) {
        ArrayList<JavaTextEdit> textEdits = new ArrayList<JavaTextEdit>();
        textEdits.add(JavaTextEdit.insertAfterTree((Tree)mit.arguments().firstToken(), (String)typeName));
        if (!methodSelect.expression().symbolType().isRawType()) {
            textEdits.add(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)castTree, (boolean)true, (Tree)mit, (boolean)false)));
        }
        return JavaQuickFix.newQuickFix((String)"Pass \"%s\" as argument", (Object[])new Object[]{typeName}).addTextEdits(textEdits).build();
    }
}

