/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.YieldStatementTree;

@Rule(key="S2438")
public class ThreadAsRunnableArgumentCheck
extends IssuableSubscriptionVisitor {
    private static final String RUNNABLE_TYPE = "java.lang.Runnable";
    private static final String THREAD_TYPE = "java.lang.Thread";
    private static final String RUNNABLE_ARRAY_TYPE = "java.lang.Runnable[]";
    private static final String THREAD_ARRAY_TYPE = "java.lang.Thread[]";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.VARIABLE, Tree.Kind.RETURN_STATEMENT, Tree.Kind.YIELD_STATEMENT, Tree.Kind.ASSIGNMENT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY);
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case VARIABLE: {
                this.visitVariable((VariableTree)tree);
                break;
            }
            case RETURN_STATEMENT: {
                this.visitReturnStatement((ReturnStatementTree)tree);
                break;
            }
            case YIELD_STATEMENT: {
                this.visitYieldStatement((YieldStatementTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.visitNewArray((NewArrayTree)tree);
                break;
            }
            case ASSIGNMENT: {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
                this.checkTypeCoercion(assignment.variable().symbolType(), assignment.expression());
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree invocation = (MethodInvocationTree)tree;
                this.visitInvocation(invocation.methodSymbol(), invocation.arguments());
                break;
            }
            case NEW_CLASS: {
                NewClassTree invocation = (NewClassTree)tree;
                this.visitInvocation(invocation.methodSymbol(), invocation.arguments());
            }
        }
    }

    private void visitVariable(VariableTree tree) {
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            this.checkTypeCoercion(tree.symbol().type(), initializer);
        }
    }

    private void visitInvocation(Symbol.MethodSymbol methodSymbol, Arguments rhsValues) {
        List lhsTypes = methodSymbol.parameterTypes();
        int nonVarargCount = lhsTypes.size() - (methodSymbol.isVarArgsMethod() ? 1 : 0);
        for (int i = 0; i < nonVarargCount; ++i) {
            this.checkTypeCoercion((Type)lhsTypes.get(i), (ExpressionTree)rhsValues.get(i));
        }
        int argumentCount = rhsValues.size();
        if (!methodSymbol.isVarArgsMethod() || argumentCount == nonVarargCount) {
            return;
        }
        Type.ArrayType arrayType = (Type.ArrayType)lhsTypes.get(nonVarargCount);
        Type elementType = arrayType.elementType();
        this.checkTypeCoercion((Type)arrayType, (ExpressionTree)rhsValues.get(nonVarargCount));
        for (int i = nonVarargCount; i < argumentCount; ++i) {
            this.checkTypeCoercion(elementType, (ExpressionTree)rhsValues.get(i));
        }
    }

    private void visitNewArray(NewArrayTree tree) {
        TypeTree lhsType = tree.type();
        if (lhsType != null && lhsType.symbolType().is(RUNNABLE_TYPE)) {
            tree.initializers().forEach(rhsValue -> this.checkTypeCoercion(lhsType.symbolType(), (ExpressionTree)rhsValue));
        }
    }

    private void visitReturnStatement(ReturnStatementTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression == null) {
            return;
        }
        Tree enclosing = ExpressionUtils.getEnclosingTree((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION});
        if (enclosing != null) {
            Type type;
            if (enclosing instanceof LambdaExpressionTree) {
                LambdaExpressionTree lambda = (LambdaExpressionTree)enclosing;
                type = lambda.symbol().returnType().type();
            } else {
                type = ((MethodTree)enclosing).returnType().symbolType();
            }
            Type lhsType = type;
            this.checkTypeCoercion(lhsType, expression);
        }
    }

    private void visitYieldStatement(YieldStatementTree tree) {
        Tree enclosing = ExpressionUtils.getEnclosingTree((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.SWITCH_EXPRESSION, Tree.Kind.SWITCH_STATEMENT});
        if (enclosing == null || enclosing.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            return;
        }
        Type lhsType = ((ExpressionTree)enclosing).symbolType();
        this.checkTypeCoercion(lhsType, tree.expression());
    }

    private void checkTypeCoercion(Type lhsType, ExpressionTree rhsValue) {
        Type rhsType = rhsValue.symbolType();
        if (lhsType.is(RUNNABLE_TYPE) && ThreadAsRunnableArgumentCheck.isNonNullSubtypeOf(rhsType, THREAD_TYPE) || lhsType.is(RUNNABLE_ARRAY_TYPE) && ThreadAsRunnableArgumentCheck.isNonNullSubtypeOf(rhsType, THREAD_ARRAY_TYPE)) {
            String message = MessageFormat.format("Replace this {0} instance with an instance of {1}.", rhsType.name(), lhsType.name());
            this.context.reportIssue((JavaCheck)this, (Tree)rhsValue, message);
        }
    }

    private static boolean isNonNullSubtypeOf(Type type, String superTypeName) {
        return !type.isNullType() && type.isSubtypeOf(superTypeName);
    }
}

