/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1132")
public class StringLiteralInsideEqualsCheck
extends IssuableSubscriptionVisitor {
    private static final int MESSAGE_ARG_MAX_LENGTH = 10;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        this.check((MethodInvocationTree)tree);
    }

    private void check(MethodInvocationTree tree) {
        ExpressionTree expressionTree = tree.methodSelect();
        if (expressionTree instanceof MemberSelectExpressionTree) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expressionTree;
            if (StringLiteralInsideEqualsCheck.isEquals(tree)) {
                LiteralTree stringLiteral = (LiteralTree)tree.arguments().get(0);
                ExpressionTree leftSideMember = memberSelectExpressionTree.expression();
                if (!leftSideMember.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                    QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)stringLiteral).withMessage("Move the " + stringLiteral.value() + " string literal on the left side of this string comparison.").withQuickFix(() -> this.computeQuickFix(stringLiteral, leftSideMember)).report();
                }
            }
        }
    }

    private static boolean isEquals(MethodInvocationTree tree) {
        IdentifierTree identifier = ((MemberSelectExpressionTree)tree.methodSelect()).identifier();
        return StringLiteralInsideEqualsCheck.isNamedEquals(identifier) && tree.arguments().size() == 1 && ((ExpressionTree)tree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private static boolean isNamedEquals(IdentifierTree tree) {
        return "equals".equals(tree.name()) || "equalsIgnoreCase".equals(tree.name());
    }

    private JavaQuickFix computeQuickFix(LiteralTree equalsArgument, ExpressionTree leftSideMember) {
        String equalsParameterValue = QuickFixHelper.contentForTree((Tree)equalsArgument, this.context);
        String quickFixMessage = String.format("Move %s on the left side of .equals", StringLiteralInsideEqualsCheck.cutTooLongString(equalsParameterValue));
        return JavaQuickFix.newQuickFix((String)quickFixMessage).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)equalsArgument, (String)QuickFixHelper.contentForTree((Tree)leftSideMember, this.context))}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)leftSideMember, (String)equalsParameterValue)}).build();
    }

    private static String cutTooLongString(String s) {
        return s.length() > 10 ? s.substring(0, 10) + "\"..." : s;
    }
}

