/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    private final Map<String, List<LiteralTree>> occurrences = new HashMap<String, List<LiteralTree>>();
    private final Map<String, VariableTree> constants = new HashMap<String, VariableTree>();

    public void scanFile(JavaFileScannerContext context) {
        this.occurrences.clear();
        this.constants.clear();
        this.scan((Tree)context.getTree());
        this.occurrences.forEach((key, literalTrees) -> {
            int literalOccurrence = literalTrees.size();
            if (this.constants.containsKey(key)) {
                VariableTree constant = this.constants.get(key);
                List<LiteralTree> duplications = literalTrees.stream().filter(literal -> literal.parent() != constant).toList();
                context.reportIssue((JavaCheck)this, (Tree)duplications.iterator().next(), "Use already-defined constant '" + String.valueOf(constant.simpleName()) + "' instead of duplicating its value here.", StringLiteralDuplicatedCheck.secondaryLocations(duplications.subList(1, duplications.size())), Integer.valueOf(literalOccurrence));
            } else if (literalOccurrence >= this.threshold) {
                LiteralTree literalTree = (LiteralTree)literalTrees.iterator().next();
                String message = literalTree.is(new Tree.Kind[]{Tree.Kind.TEXT_BLOCK}) ? "Define a constant instead of duplicating this text block " + literalOccurrence + " times." : "Define a constant instead of duplicating this literal \"" + key + "\" " + literalOccurrence + " times.";
                context.reportIssue((JavaCheck)this, (Tree)literalTree, message, StringLiteralDuplicatedCheck.secondaryLocations(literalTrees), Integer.valueOf(literalOccurrence));
            }
        });
    }

    private static List<JavaFileScannerContext.Location> secondaryLocations(Collection<LiteralTree> literalTrees) {
        return literalTrees.stream().map(element -> new JavaFileScannerContext.Location("Duplication", (Tree)element)).toList();
    }

    public void visitLiteral(LiteralTree tree) {
        String literal;
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK}) && (literal = tree.value()).length() >= 7 && !StringLiteralDuplicatedCheck.isStringLiteralFragment((ExpressionTree)tree)) {
            String stringValue = LiteralUtils.getAsStringValue((LiteralTree)tree).replace("\\n", "\n");
            this.occurrences.computeIfAbsent(stringValue, key -> new ArrayList()).add(tree);
        }
    }

    private static boolean isStringLiteralFragment(ExpressionTree tree) {
        return StringLiteralDuplicatedCheck.isStringLiteral((Tree)tree) && (StringLiteralDuplicatedCheck.isStringLiteral((Tree)StringLiteralDuplicatedCheck.getNextOperand(tree)) || StringLiteralDuplicatedCheck.isStringLiteral((Tree)StringLiteralDuplicatedCheck.getPreviousOperand(tree)));
    }

    private static boolean isStringLiteral(@Nullable Tree tree) {
        return tree != null && tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    @Nullable
    private static ExpressionTree getNextOperand(ExpressionTree tree) {
        BinaryExpressionTree binary = StringLiteralDuplicatedCheck.asPlusExpression(tree.parent());
        if (binary == null) {
            return null;
        }
        if (tree == binary.leftOperand()) {
            return binary.rightOperand();
        }
        return (binary = StringLiteralDuplicatedCheck.asPlusExpression(binary.parent())) != null ? binary.rightOperand() : null;
    }

    @Nullable
    private static ExpressionTree getPreviousOperand(ExpressionTree tree) {
        BinaryExpressionTree binary = StringLiteralDuplicatedCheck.asPlusExpression(tree.parent());
        if (binary == null) {
            return null;
        }
        if (tree == binary.leftOperand()) {
            return null;
        }
        ExpressionTree left = binary.leftOperand();
        return (binary = StringLiteralDuplicatedCheck.asPlusExpression((Tree)left)) != null ? binary.rightOperand() : binary;
    }

    @Nullable
    private static BinaryExpressionTree asPlusExpression(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PLUS}) ? (BinaryExpressionTree)tree : null;
    }

    public void visitVariable(VariableTree tree) {
        ExpressionTree initializer = tree.initializer();
        if (initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK}) && ModifiersUtils.hasAll((ModifiersTree)tree.modifiers(), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL})) {
            String stringValue = LiteralUtils.getAsStringValue((LiteralTree)((LiteralTree)initializer)).replace("\\n", "\n");
            this.constants.putIfAbsent(stringValue, tree);
            return;
        }
        super.visitVariable(tree);
    }

    public void visitMethod(MethodTree tree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.DEFAULT)) {
            return;
        }
        super.visitMethod(tree);
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }
}

