/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3252")
public class StaticMemberAccessCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers LIST_SET_OF = MethodMatchers.create().ofTypes(new String[]{"java.util.List", "java.util.Set"}).names(new String[]{"of"}).withAnyParameters().build();
    private String currentPackage = "";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.MEMBER_SELECT, Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof CompilationUnitTree) {
            CompilationUnitTree file = (CompilationUnitTree)tree;
            PackageDeclarationTree packageDecl = file.packageDeclaration();
            this.currentPackage = packageDecl == null ? "" : PackageUtils.packageName((PackageDeclarationTree)packageDecl, (String)".");
            return;
        }
        MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
        Symbol symbol = mse.identifier().symbol();
        if (symbol.isStatic() && !StaticMemberAccessCheck.isListOrSetOf(mse)) {
            ExpressionTree expression = mse.expression();
            Symbol owner = symbol.owner();
            Type staticType = owner.type();
            Type expressionType = expression.symbolType();
            boolean memberOwnerIsInCurrentPackage = this.currentPackage.equals(StaticMemberAccessCheck.classPackage(expressionType));
            if (!(staticType.isUnknown() || expressionType.isUnknown() || expressionType.erasure().equals((Object)staticType.erasure()) || !memberOwnerIsInCurrentPackage && !owner.isPublic())) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)mse.identifier()).withMessage("Use static access with \"%s\" for \"%s\".", new Object[]{staticType.fullyQualifiedName(), symbol.name()}).withQuickFix(() -> StaticMemberAccessCheck.quickFix(expression, staticType)).report();
            }
        }
    }

    private static String classPackage(Type classType) {
        int endPackage = classType.fullyQualifiedName().lastIndexOf(46);
        return endPackage == -1 ? "" : classType.fullyQualifiedName().substring(0, endPackage);
    }

    private static boolean isListOrSetOf(MemberSelectExpressionTree mse) {
        Tree parent = mse.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && LIST_SET_OF.matches((MethodInvocationTree)parent);
    }

    private static JavaQuickFix quickFix(ExpressionTree expression, Type staticType) {
        String oldType = expression.symbolType().name();
        String newType = staticType.name();
        return JavaQuickFix.newQuickFix((String)String.format("Use \"%s\" instead of \"%s\"", newType, oldType)).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)expression, (String)newType)}).build();
    }
}

