/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2226")
public class ServletInstanceFieldCheck
extends IssuableSubscriptionVisitor {
    private final List<VariableTree> issuableVariables = new ArrayList<VariableTree>();
    private final List<VariableTree> excludedVariables = new ArrayList<VariableTree>();
    private static final MethodMatchers INIT_METHOD_WITH_PARAM_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"javax.servlet.Servlet"}).names(new String[]{"init"}).addParametersMatcher(new String[]{"javax.servlet.ServletConfig"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"jakarta.servlet.Servlet"}).names(new String[]{"init"}).addParametersMatcher(new String[]{"jakarta.servlet.ServletConfig"}).build()});
    private static final MethodMatchers INIT_METHOD_NO_PARAMS_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"javax.servlet.GenericServlet", "jakarta.servlet.GenericServlet"}).names(new String[]{"init"}).addWithoutParametersMatcher().build();
    private static final List<String> ANNOTATIONS_EXCLUDING_FIELDS = Arrays.asList("javax.inject.Inject", "jakarta.inject.Inject", "javax.ejb.EJB", "jakarta.ejb.EJB", "javax.annotation.Resource", "jakarta.annotation.Resource");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.METHOD);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.reportIssuesOnVariable();
    }

    public void visitNode(Tree tree) {
        VariableTree variable;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && ServletInstanceFieldCheck.isServletInit((MethodTree)tree)) {
            tree.accept((TreeVisitor)new AssignmentVisitor());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ServletInstanceFieldCheck.isOwnedByAServlet(variable = (VariableTree)tree) && !ServletInstanceFieldCheck.isExcluded(variable)) {
            this.issuableVariables.add(variable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcluded(VariableTree variable) {
        SymbolMetadata varMetadata = variable.symbol().metadata();
        if (ServletInstanceFieldCheck.isStaticOrFinal(variable)) return true;
        if (!ANNOTATIONS_EXCLUDING_FIELDS.stream().anyMatch(arg_0 -> ((SymbolMetadata)varMetadata).isAnnotatedWith(arg_0))) return false;
        return true;
    }

    private static boolean isServletInit(MethodTree tree) {
        return INIT_METHOD_WITH_PARAM_MATCHER.matches(tree) || INIT_METHOD_NO_PARAMS_MATCHER.matches(tree);
    }

    private void reportIssuesOnVariable() {
        this.issuableVariables.removeAll(this.excludedVariables);
        for (VariableTree variable : this.issuableVariables) {
            this.reportIssue((Tree)variable.simpleName(), "Remove this misleading mutable servlet instance field or make it \"static\" and/or \"final\"");
        }
        this.issuableVariables.clear();
        this.excludedVariables.clear();
    }

    private static boolean isOwnedByAServlet(VariableTree variable) {
        Symbol owner = variable.symbol().owner();
        if (!owner.isTypeSymbol() || !variable.parent().is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            return false;
        }
        Type ownerType = owner.type();
        return ownerType.isSubtypeOf("javax.servlet.http.HttpServlet") || ownerType.isSubtypeOf("jakarta.servlet.http.HttpServlet") || ownerType.isSubtypeOf("org.apache.struts.action.Action");
    }

    private static boolean isStaticOrFinal(VariableTree variable) {
        return ModifiersUtils.hasAnyOf((ModifiersTree)variable.modifiers(), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL});
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            IdentifierTree identifier;
            MemberSelectExpressionTree memberSelectTree;
            ExpressionTree expressionTree;
            ExpressionTree variable = tree.variable();
            if (variable instanceof IdentifierTree) {
                IdentifierTree identifier2 = (IdentifierTree)variable;
                this.addVariableToExcluded(identifier2.symbol().declaration());
            } else if (variable instanceof MemberSelectExpressionTree && (expressionTree = (memberSelectTree = (MemberSelectExpressionTree)variable).expression()) instanceof IdentifierTree && "this".equals((identifier = (IdentifierTree)expressionTree).identifierToken().text())) {
                this.addVariableToExcluded(memberSelectTree.identifier().symbol().declaration());
            }
        }

        private void addVariableToExcluded(@Nullable Tree declaration) {
            if (declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                ServletInstanceFieldCheck.this.excludedVariables.add((VariableTree)declaration);
            }
        }
    }
}

