/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6876")
public class ReversedMethodSequencedCollectionCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String ISSUE_MESSAGE = "Use the \"reversed()\" method instead of manually iterating the list in reverse.";
    private static final MethodMatchers LIST_ITERATOR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.List"}).names(new String[]{"listIterator"}).addParametersMatcher(new String[]{"int"}).build();
    private static final MethodMatchers LIST_SIZE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.List"}).names(new String[]{"size"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers LIST_HAS_PREVIOUS_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.ListIterator"}).names(new String[]{"hasPrevious"}).addWithoutParametersMatcher().build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree forStatement = (ForStatementTree)tree;
        ListTree initializerStatements = forStatement.initializer();
        if (initializerStatements.size() != 1) {
            return;
        }
        StatementTree initializer = (StatementTree)initializerStatements.get(0);
        ExpressionTree condition = forStatement.condition();
        if (condition == null) {
            return;
        }
        if (ReversedMethodSequencedCollectionCheck.isInitializerListIteratorFromLast((Tree)initializer) && ReversedMethodSequencedCollectionCheck.isConditionHasPrevious((Tree)condition)) {
            this.reportIssue((Tree)forStatement.forKeyword(), ISSUE_MESSAGE);
        }
    }

    private static boolean isInitializerListIteratorFromLast(Tree initializer) {
        MethodInvocationTree arg;
        MethodInvocationTree variableInitializer;
        VariableTree variable;
        Object object;
        return initializer instanceof VariableTree && (object = (variable = (VariableTree)initializer).initializer()) instanceof MethodInvocationTree && LIST_ITERATOR_MATCHER.matches(variableInitializer = (MethodInvocationTree)object) && (object = variableInitializer.arguments().get(0)) instanceof MethodInvocationTree && LIST_SIZE_MATCHER.matches(arg = (MethodInvocationTree)object);
    }

    private static boolean isConditionHasPrevious(Tree condition) {
        MethodInvocationTree invocation;
        return condition instanceof MethodInvocationTree && LIST_HAS_PREVIOUS_MATCHER.matches(invocation = (MethodInvocationTree)condition);
    }
}

