/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6877")
public class ReverseSequencedCollectionCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String MESSAGE = "Remove this \"reverse\" statement and replace \"%s\" with \"%s.reversed()\" after.";
    private static final String ADD_ALL = "addAll";
    private static final MethodMatchers LIST_CONSTRUCTORS = MethodMatchers.create().ofTypes(new String[]{"java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.concurrent.CopyOnWriteArrayList", "javax.management.AttributeList", "javax.management.relation.RoleList", "javax.management.relation.RoleUnresolvedList"}).constructor().withAnyParameters().build();
    private static final MethodMatchers LIST_READONLY_CONSUMERS = MethodMatchers.create().ofSubTypes(new String[]{"java.util.List"}).names(new String[]{"addAll", "copyOf"}).addParametersMatcher(new String[]{"java.util.Collection"}).build();
    private static final MethodMatchers LIST_READ_ACCESSORS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"clone", "getClass", "getFirst", "getLast", "hashCode", "isEmpty", "listIterator", "parallelStream", "size", "spliterator", "stream", "toArray", "toString", "wait", "notify", "notifyAll"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"contains", "containsAll", "equals", "forEach", "get", "indexOf", "lastIndexOf", "listIterator", "toArray"}).addParametersMatcher(new String[]{"*"}).build()});
    private static final MethodMatchers LIST_WRITE_ACCESSORS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"clear", "removeFirst", "removeLast"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"add", "addAll", "addFirst", "addLast", "remove", "removeAll", "replaceAll", "retainAll", "sort"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofAnyType().names(new String[]{"add", "addAll", "set"}).addParametersMatcher(new String[]{"int", "*"}).build()});
    private static final Set<Tree.Kind> SUPPORTED_REVERSE_SCOPE_CHILD_KINDS = EnumSet.of(Tree.Kind.IDENTIFIER, new Tree.Kind[]{Tree.Kind.ARGUMENTS, Tree.Kind.METHOD_INVOCATION, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.MEMBER_SELECT, Tree.Kind.BLOCK, Tree.Kind.IF_STATEMENT});
    private static final Set<Tree.Kind> SUPPORTED_USAGE_SCOPE_CHILD_KINDS = EnumSet.of(Tree.Kind.IDENTIFIER, new Tree.Kind[]{Tree.Kind.MEMBER_SELECT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.ASSIGNMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.BLOCK, Tree.Kind.IF_STATEMENT});

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).names(new String[]{"reverse"}).addParametersMatcher(new String[]{"java.util.List"}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree methodInvocation) {
        Arguments reverseMethodArguments = methodInvocation.arguments();
        if (reverseMethodArguments.isEmpty() || !((ExpressionTree)reverseMethodArguments.get(0)).is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return;
        }
        IdentifierTree reverseMethodArgument = (IdentifierTree)reverseMethodArguments.get(0);
        Symbol symbol = reverseMethodArgument.symbol();
        if (!symbol.isLocalVariable() || symbol.isParameter()) {
            return;
        }
        Symbol.VariableSymbol reverseMethodArgumentSymbol = (Symbol.VariableSymbol)symbol;
        if (ReverseSequencedCollectionCheck.areUsagesCompatibleWithReversed(reverseMethodArgument, reverseMethodArgumentSymbol)) {
            String message = String.format(MESSAGE, reverseMethodArgumentSymbol.name(), reverseMethodArgumentSymbol.name());
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), message);
        }
    }

    private static boolean areUsagesCompatibleWithReversed(IdentifierTree reverseArgument, Symbol.VariableSymbol listSymbol) {
        VariableTree declaration = listSymbol.declaration();
        Tree reverseParentScope = ReverseSequencedCollectionCheck.findParentScope((Tree)reverseArgument, SUPPORTED_REVERSE_SCOPE_CHILD_KINDS);
        if (declaration == null || reverseParentScope == null || !ReverseSequencedCollectionCheck.isInitializerCompatibleWithReversed(declaration, reverseParentScope)) {
            return false;
        }
        for (IdentifierTree usage : listSymbol.usages()) {
            if (ReverseSequencedCollectionCheck.isUsageCompatibleWithReversed(usage, reverseArgument, reverseParentScope)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInitializerCompatibleWithReversed(VariableTree declaration, Tree reverseParentScope) {
        if (declaration.parent() instanceof ForEachStatement) {
            return false;
        }
        ExpressionTree initializer = declaration.initializer();
        if (initializer == null) {
            return true;
        }
        return ReverseSequencedCollectionCheck.isNullOrListConstructor(initializer) && ReverseSequencedCollectionCheck.matchReverseParentSafeScope(declaration.parent(), reverseParentScope);
    }

    private static boolean isUsageCompatibleWithReversed(IdentifierTree usage, IdentifierTree reverseArgument, Tree reverseParentScope) {
        if (usage == reverseArgument || ReverseSequencedCollectionCheck.isCompatibleReadUsage(usage)) {
            return true;
        }
        if (ReverseSequencedCollectionCheck.isAfter(usage, reverseArgument)) {
            return false;
        }
        return ReverseSequencedCollectionCheck.isCompatibleWriteUsage(usage) && ReverseSequencedCollectionCheck.matchReverseParentSafeScope((Tree)usage, reverseParentScope);
    }

    private static boolean isCompatibleWriteUsage(IdentifierTree usage) {
        AssignmentExpressionTree assignmentExpression;
        if (ReverseSequencedCollectionCheck.matchAccessor(usage, LIST_WRITE_ACCESSORS)) {
            return true;
        }
        Tree tree = usage.parent();
        return tree instanceof AssignmentExpressionTree && ReverseSequencedCollectionCheck.isNullOrListConstructor((assignmentExpression = (AssignmentExpressionTree)tree).expression());
    }

    private static boolean isCompatibleReadUsage(IdentifierTree usage) {
        ForEachStatement forEachStatement;
        if (ReverseSequencedCollectionCheck.matchAccessor(usage, LIST_READ_ACCESSORS)) {
            return true;
        }
        Tree parent = usage.parent();
        if (parent instanceof Arguments) {
            Arguments arguments = (Arguments)parent;
            return ReverseSequencedCollectionCheck.isListReadOnlyConsumer(arguments.parent());
        }
        return parent instanceof ForEachStatement && (forEachStatement = (ForEachStatement)parent).expression() == usage;
    }

    private static boolean matchAccessor(IdentifierTree usage, MethodMatchers methodMatchers) {
        MethodInvocationTree methodInvocation;
        Tree grandParent;
        MemberSelectExpressionTree memberSelect;
        Tree parent = usage.parent();
        if (parent instanceof MemberSelectExpressionTree && (memberSelect = (MemberSelectExpressionTree)parent).expression() == usage && (grandParent = parent.parent()) instanceof MethodInvocationTree && (methodInvocation = (MethodInvocationTree)grandParent).methodSelect() == parent) {
            return methodMatchers.matches(methodInvocation);
        }
        return false;
    }

    private static boolean isAfter(IdentifierTree a, IdentifierTree b) {
        return a.identifierToken().range().start().isAfter(b.identifierToken().range().start());
    }

    private static boolean isNullOrListConstructor(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return true;
        }
        return ReverseSequencedCollectionCheck.isListConstructor((Tree)expression);
    }

    private static boolean isListReadOnlyConsumer(@Nullable Tree tree) {
        if (tree instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
            return LIST_READONLY_CONSUMERS.matches(methodInvocation);
        }
        return ReverseSequencedCollectionCheck.isListConstructor(tree);
    }

    private static boolean isListConstructor(@Nullable Tree tree) {
        NewClassTree newClassTree;
        return tree instanceof NewClassTree && LIST_CONSTRUCTORS.matches(newClassTree = (NewClassTree)tree);
    }

    private static Tree findParentScope(@Nullable Tree tree, Set<Tree.Kind> supportedChildKinds) {
        while (tree != null && supportedChildKinds.contains(tree.kind())) {
            tree = tree.parent();
        }
        return tree;
    }

    private static boolean matchReverseParentSafeScope(@Nullable Tree tree, Tree reverseParentScope) {
        return ReverseSequencedCollectionCheck.findParentScope(tree, SUPPORTED_USAGE_SCOPE_CHILD_KINDS) == reverseParentScope;
    }
}

