/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S4738")
public class ReplaceGuavaWithJavaCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String USE_INSTEAD = "Use \"%s\" instead.";
    private static final String GUAVA_BASE_ENCODING = "com.google.common.io.BaseEncoding";
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    private static final String GUAVA_FILES = "com.google.common.io.Files";
    private static final String GUAVA_IMMUTABLE_LIST = "com.google.common.collect.ImmutableList";
    private static final Map<String, String> GUAVA_TO_JAVA_UTIL_TYPES = MapBuilder.newMap().put((Object)"com.google.common.base.Predicate", (Object)"java.util.function.Predicate").put((Object)"com.google.common.base.Function", (Object)"java.util.function.Function").put((Object)"com.google.common.base.Supplier", (Object)"java.util.function.Supplier").put((Object)"com.google.common.base.Optional", (Object)"java.util.Optional").build();
    private static final Map<String, String> GUAVA_OPTIONAL_TO_JAVA_UTIL_METHODS = MapBuilder.newMap().put((Object)"of", (Object)"of").put((Object)"absent", (Object)"empty").put((Object)"fromNullable", (Object)"ofNullable").build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{GUAVA_BASE_ENCODING}).names(new String[]{"base64", "base64Url"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{GUAVA_OPTIONAL}).names(new String[]{"absent"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{GUAVA_OPTIONAL}).names(new String[]{"fromNullable", "of"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{GUAVA_FILES}).names(new String[]{"createTempDir"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{GUAVA_IMMUTABLE_LIST}).names(new String[]{"of"}).withAnyParameters().build()});
    }

    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> kinds = new ArrayList<Tree.Kind>(super.nodesToVisit());
        kinds.add(Tree.Kind.VARIABLE);
        return kinds;
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.checkTypeToReplace((VariableTree)tree);
        } else {
            super.visitNode(tree);
        }
    }

    private void checkTypeToReplace(VariableTree variableTree) {
        String fullyQualifiedTypeName = variableTree.type().symbolType().fullyQualifiedName();
        if (GUAVA_TO_JAVA_UTIL_TYPES.containsKey(fullyQualifiedTypeName)) {
            this.reportIssue((Tree)variableTree.type(), this.replacementMessage(GUAVA_TO_JAVA_UTIL_TYPES.get(fullyQualifiedTypeName)));
        }
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        switch (mit.methodSymbol().owner().type().fullyQualifiedName()) {
            case "com.google.common.io.BaseEncoding": {
                this.reportIssue((Tree)mit, this.replacementMessage("java.util.Base64"));
                break;
            }
            case "com.google.common.base.Optional": {
                this.reportIssue((Tree)mit, this.replacementMessage("java.util.Optional." + GUAVA_OPTIONAL_TO_JAVA_UTIL_METHODS.get(mit.methodSymbol().name())));
                break;
            }
            case "com.google.common.io.Files": {
                this.reportIssue((Tree)mit, this.replacementMessage("java.nio.file.Files.createTempDirectory"));
                break;
            }
            case "com.google.common.collect.ImmutableList": {
                this.reportJava9Issue(mit, "java.util.List.of()");
                break;
            }
        }
    }

    private void reportJava9Issue(MethodInvocationTree mit, String replacement) {
        if (this.context.getJavaVersion().isJava9Compatible()) {
            this.reportIssue((Tree)mit, this.replacementMessage(replacement));
        }
    }

    private String replacementMessage(String replacement) {
        return String.format(USE_INSTEAD, replacement) + this.context.getJavaVersion().java8CompatibilityMessage();
    }
}

