/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6889")
public class ReleaseSensorsCheck
extends IssuableSubscriptionVisitor {
    private static final String ACQUIRE = "acquire";
    private static final String RELEASE = "release";
    private AcquireReleaseStatus[] statuses;

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.initStatuses();
    }

    public void leaveFile(JavaFileScannerContext context) {
        Arrays.stream(this.statuses).filter(status -> !status.released).forEach(status -> status.acquireInvocations.forEach(mit -> this.reportIssue((Tree)mit, "Make sure to release this sensor after use.")));
        this.statuses = null;
    }

    private void initStatuses() {
        this.statuses = (AcquireReleaseStatus[])IntStream.range(0, AcquireReleaseSensor.values().length).mapToObj(i -> new AcquireReleaseStatus()).toArray(AcquireReleaseStatus[]::new);
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Arrays.stream(AcquireReleaseSensor.values()).filter(sensor -> ReleaseSensorsCheck.isMethodMatched(tree, sensor.acquireMethodMatcher)).findAny().ifPresent(sensor -> this.statuses[sensor.ordinal()].acquireInvocations.add(tree));
        Arrays.stream(AcquireReleaseSensor.values()).filter(sensor -> ReleaseSensorsCheck.isMethodMatched(tree, sensor.releaseMethodMatcher)).findAny().ifPresent(sensor -> {
            this.statuses[sensor.ordinal()].released = true;
        });
    }

    private static boolean isMethodMatched(Tree tree, MethodMatchers methodMatchers) {
        switch (tree.kind()) {
            case METHOD_INVOCATION: {
                return methodMatchers.matches((MethodInvocationTree)tree);
            }
            case NEW_CLASS: {
                return methodMatchers.matches((NewClassTree)tree);
            }
        }
        return false;
    }

    private static class AcquireReleaseStatus {
        List<Tree> acquireInvocations = new LinkedList<Tree>();
        boolean released = false;

        private AcquireReleaseStatus() {
        }
    }

    private static enum AcquireReleaseSensor {
        LOCATION_MANAGER("android.location.LocationManager", "requestLocationUpdates", "removeUpdates"),
        SENSOR_MANAGER("android.hardware.SensorManager", "registerListener", "unregisterListener"),
        VIRTUAL_DISPLAY("android.media.projection.MediaProjection", "createVirtualDisplay", "android.hardware.display.VirtualDisplay", "release"),
        CAMERA("android.hardware.Camera", "open", "release"),
        CAMERA2("android.hardware.camera2.CameraManager", "openCamera", "android.hardware.camera2.CameraDevice", "close"),
        POWER_MANAGER("android.os.PowerManager$WakeLock", "acquire", "release"),
        WIFI_MANAGER("android.net.wifi.WifiManager$MulticastLock", "acquire", "release"),
        SOUND_POOL("android.media.SoundPool$Builder", "build", "android.media.SoundPool", "release"),
        VISUALIZER("android.media.audiofx.Visualizer", "<init>", "release"),
        MEDIA_PLAYER("android.media.MediaPlayer", "<init>", "release"),
        MEDIA_RECORDER("android.media.MediaRecorder", "<init>", "release");

        private final MethodMatchers acquireMethodMatcher;
        private final MethodMatchers releaseMethodMatcher;

        private AcquireReleaseSensor(String sensorClass, String acquireMethod, String releaseMethod) {
            this.acquireMethodMatcher = MethodMatchers.create().ofTypes(new String[]{sensorClass}).names(new String[]{acquireMethod}).withAnyParameters().build();
            this.releaseMethodMatcher = MethodMatchers.create().ofTypes(new String[]{sensorClass}).names(new String[]{releaseMethod}).withAnyParameters().build();
        }

        private AcquireReleaseSensor(String acquireSensorClass, String acquireMethod, String releaseSensorClass, String releaseMethod) {
            this.acquireMethodMatcher = MethodMatchers.create().ofTypes(new String[]{acquireSensorClass}).names(new String[]{acquireMethod}).withAnyParameters().build();
            this.releaseMethodMatcher = MethodMatchers.create().ofTypes(new String[]{releaseSensorClass}).names(new String[]{releaseMethod}).withAnyParameters().build();
        }
    }
}

