/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.NullabilityDataUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6665")
public class RedundantNullabilityAnnotationsCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Remove redundant annotation %s as inside scope annotation %s.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INTERFACE, Tree.Kind.CLASS, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (Objects.requireNonNull(classTree.symbol().owner()).isPackageSymbol()) {
            SymbolMetadata.NullabilityData classNullabilityData = classTree.symbol().metadata().nullabilityData(SymbolMetadata.NullabilityTarget.CLASS);
            if (classNullabilityData.isNonNull(SymbolMetadata.NullabilityLevel.PACKAGE, false, false)) {
                this.checkMembers(classNullabilityData, classTree, NULLABILITY_SCOPE.NON_NULLABLE);
            } else if (classNullabilityData.isNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, false)) {
                this.checkMembers(classNullabilityData, classTree, NULLABILITY_SCOPE.NULLABLE);
            }
        }
    }

    private void checkMembers(SymbolMetadata.NullabilityData classNullabilityData, ClassTree tree, NULLABILITY_SCOPE scope) {
        tree.members().forEach(member -> {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)member;
                this.checkSymbol(classNullabilityData, (Tree)variableTree, SymbolMetadata.NullabilityLevel.VARIABLE, variableTree.symbol(), scope);
            } else if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                this.checkMethod(classNullabilityData, (MethodTree)member, scope);
            } else if (member.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.RECORD})) {
                this.checkInnerClass(classNullabilityData, (ClassTree)member, scope);
            }
        });
    }

    private void checkInnerClass(SymbolMetadata.NullabilityData classNullabilityData, ClassTree tree, NULLABILITY_SCOPE scope) {
        SymbolMetadata.NullabilityData innerNullabilityData = tree.symbol().metadata().nullabilityData(SymbolMetadata.NullabilityTarget.CLASS);
        if (innerNullabilityData.isNonNull(SymbolMetadata.NullabilityLevel.CLASS, false, false)) {
            if (scope.equals((Object)NULLABILITY_SCOPE.NON_NULLABLE)) {
                this.reportIssue((Tree)tree, innerNullabilityData, classNullabilityData);
            }
            this.checkMembers(innerNullabilityData, tree, NULLABILITY_SCOPE.NON_NULLABLE);
        } else if (innerNullabilityData.isNullable(SymbolMetadata.NullabilityLevel.CLASS, false, false)) {
            if (scope.equals((Object)NULLABILITY_SCOPE.NULLABLE)) {
                this.reportIssue((Tree)tree, innerNullabilityData, classNullabilityData);
            }
            this.checkMembers(innerNullabilityData, tree, NULLABILITY_SCOPE.NULLABLE);
        }
    }

    private void checkMethod(SymbolMetadata.NullabilityData classNullabilityData, MethodTree method, NULLABILITY_SCOPE scope) {
        this.checkSymbol(classNullabilityData, (Tree)method, SymbolMetadata.NullabilityLevel.METHOD, (Symbol)method.symbol(), scope);
        method.parameters().forEach(parameter -> this.checkSymbol(classNullabilityData, (Tree)parameter, SymbolMetadata.NullabilityLevel.VARIABLE, parameter.symbol(), scope));
    }

    private void checkSymbol(SymbolMetadata.NullabilityData classNullabilityData, Tree tree, SymbolMetadata.NullabilityLevel treeLevel, Symbol symbol, NULLABILITY_SCOPE scope) {
        SymbolMetadata.NullabilityData symbolNullabilityData = symbol.metadata().nullabilityData();
        if (symbolNullabilityData.isNonNull(treeLevel, false, false) && scope.equals((Object)NULLABILITY_SCOPE.NON_NULLABLE)) {
            this.reportIssue(tree, symbolNullabilityData, classNullabilityData);
        }
        if (symbolNullabilityData.isNullable(treeLevel, false, false) && scope.equals((Object)NULLABILITY_SCOPE.NULLABLE)) {
            this.reportIssue(tree, symbolNullabilityData, classNullabilityData);
        }
    }

    private void reportIssue(Tree reportLocation, SymbolMetadata.NullabilityData directNullabilityData, SymbolMetadata.NullabilityData higherNullabilityData) {
        Optional<String> directNullabilityDataAsString = NullabilityDataUtils.nullabilityAsString(directNullabilityData);
        Optional<String> higherNullabilityDataAsString = NullabilityDataUtils.nullabilityAsString(higherNullabilityData);
        if (directNullabilityDataAsString.isPresent() && higherNullabilityDataAsString.isPresent()) {
            this.reportIssue(reportLocation, String.format(ISSUE_MESSAGE, directNullabilityDataAsString.get(), higherNullabilityDataAsString.get()));
        }
    }

    private static enum NULLABILITY_SCOPE {
        NULLABLE,
        NON_NULLABLE;

    }
}

