/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.PatternInstanceOfTree;
import org.sonar.plugins.java.api.tree.PatternTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypePatternTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6878")
public class RecordPatternInsteadOfFieldAccessCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final List<String> ALLOWED_METHODS = List.of("toString", "hashCode", "equals");

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.PATTERN_INSTANCE_OF, Tree.Kind.CASE_LABEL);
    }

    public void visitNode(Tree tree) {
        if (tree instanceof PatternInstanceOfTree) {
            TypePatternTree typePattern;
            PatternInstanceOfTree instanceOf = (PatternInstanceOfTree)tree;
            PatternTree pattern = instanceOf.pattern();
            if (pattern instanceof TypePatternTree && RecordPatternInsteadOfFieldAccessCheck.isRecordPattern(typePattern = (TypePatternTree)pattern)) {
                this.checkTypePatternVariableUsage(typePattern.patternVariable());
            }
        } else {
            this.checkCaseLabel((CaseLabelTree)tree);
        }
    }

    private void checkCaseLabel(CaseLabelTree caseLabel) {
        Optional<TypePatternTree> typePattern = RecordPatternInsteadOfFieldAccessCheck.getRecordTypePatternFromCaseGroup(caseLabel);
        typePattern.ifPresent(typePatternTree -> this.checkTypePatternVariableUsage(typePatternTree.patternVariable()));
    }

    private static Optional<TypePatternTree> getRecordTypePatternFromCaseGroup(CaseLabelTree caseLabel) {
        TypePatternTree typePattern;
        Object e;
        if (caseLabel.expressions().size() == 1 && (e = caseLabel.expressions().get(0)) instanceof TypePatternTree && RecordPatternInsteadOfFieldAccessCheck.isRecordPattern(typePattern = (TypePatternTree)e)) {
            return Optional.of(typePattern);
        }
        return Optional.empty();
    }

    private void checkTypePatternVariableUsage(VariableTree patternVariable) {
        HashSet<MemberSelectExpressionTree> secondaryLocationsTrees = new HashSet<MemberSelectExpressionTree>();
        Symbol.TypeSymbol recordSymbol = patternVariable.symbol().type().symbol();
        for (Tree usage : patternVariable.symbol().usages()) {
            MemberSelectExpressionTree mse;
            Tree tree = usage.parent();
            if (tree instanceof MemberSelectExpressionTree && RecordPatternInsteadOfFieldAccessCheck.isNotRecordGetter(mse = (MemberSelectExpressionTree)tree)) {
                secondaryLocationsTrees.add(mse);
                continue;
            }
            return;
        }
        if (RecordPatternInsteadOfFieldAccessCheck.isEveryRecordComponentUsed(secondaryLocationsTrees, recordSymbol)) {
            this.reportIssue((Tree)patternVariable, "Use the record pattern instead of this pattern match variable.", RecordPatternInsteadOfFieldAccessCheck.getSecondaryLocations(secondaryLocationsTrees), null);
        }
    }

    private static boolean isEveryRecordComponentUsed(Set<MemberSelectExpressionTree> secondaryLocationsTrees, Symbol.TypeSymbol recordSymbol) {
        Set<String> recordComponentNames = RecordPatternInsteadOfFieldAccessCheck.recordComponentNames(recordSymbol);
        return !recordComponentNames.isEmpty() && secondaryLocationsTrees.stream().map(mse -> mse.identifier().name()).collect(Collectors.toSet()).equals(recordComponentNames);
    }

    private static boolean isNotRecordGetter(MemberSelectExpressionTree mse) {
        return !ALLOWED_METHODS.contains(mse.identifier().name());
    }

    private static List<JavaFileScannerContext.Location> getSecondaryLocations(Set<MemberSelectExpressionTree> secondaryLocationsTrees) {
        return secondaryLocationsTrees.stream().map(tree -> new JavaFileScannerContext.Location("Replace this getter with the respective record pattern component", (Tree)tree)).toList();
    }

    private static boolean isRecordPattern(TypePatternTree typePattern) {
        return typePattern.patternVariable().type().symbolType().isSubtypeOf("java.lang.Record");
    }

    private static Set<String> recordComponentNames(Symbol.TypeSymbol recordSymbol) {
        return recordSymbol.memberSymbols().stream().filter(Symbol::isVariableSymbol).map(Symbol.VariableSymbol.class::cast).map(Symbol::name).collect(Collectors.toSet());
    }
}

